/**
 * Converts an arrival time from milliseconds to minutes.
 *
 * @param {number} arrivalTime - The arrival time in milliseconds.
 * @returns {number} The number of minutes until arrival.
 *                   Returns `0` if less than one minute remains, or `-99` if `arrivalTime` is not a valid number.
 */
function getRemainingMinutes(arrivalTime) {
  const millis = Number(arrivalTime);

  if (isNaN(millis)) {
    print(`JOANNET NEUE WARNING>> getRemainingMinutes(): Not a number! Type is ${typeof arrivalTime} and value is '${arrivalTime}'. Returning -99...`);
    return -99;
  } else {
    return Math.floor((millis - Date.now()) / 60000);
  }
}