/**
 * Converts an arrival time from milliseconds to seconds.
 *
 * @param {number} arrivalTime - The arrival time in milliseconds.
 * @returns {number} The number of seconds until arrival.
 *                   Returns `-99` if `arrivalTime` is not a valid number.
 */
function getRemainingSeconds(arrivalTime) {
  const millis = Number(arrivalTime);

  if (isNaN(millis)) {
    print(`JOANNET NEUE WARNING>> getRemainingSeconds(): Not a number! Type is ${typeof arrivalTime} and value is '${arrivalTime}'. Returning -99...`);
    return -99;
  } else {
    return Math.floor((millis - Date.now()) / 1000);
  }
}