/**
 * Converts a decimal color value to a hex color string.
 *
 * If the provided value is not a valid number, it defaults to 0 (`#000000`).
 *
 * @param {number|string} color - The color value in decimal or a numeric string. Defaults to 0 if invalid or not provided.
 * @returns {string} The color in hex format, e.g., "#RRGGBB".
 */
function parseColor(color) {
  let num = Number(color);
  if (isNaN(num)) num = 0;
  return `#${num.toString(16).padStart(6, "0")}`;
}