/**
 * Generates a random number within a specified range.
 *
 * @param {number} [min=0] - The minimum value of the range (inclusive). Defaults to 0.
 * @param {number} [max=1] - The maximum value of the range (inclusive). Defaults to 1.
 * @param {boolean} [int=false] - If true, returns an integer number (no decimals). Defaults to false.
 * @returns {number} A random number within the specified range. Returns an integer if `int` is true.
 */
function randomNumber(min = 0, max = 1, int = false) {
  if (int) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
  } else {
    return Math.random() * (max - min) + min;
  }
}