importPackage(Packages.java.lang);

/**
 * Executes a callback after a specified delay without blocking the main thread.
 * This function is a Rhino JS implementation of `setTimeout` using Java threads.
 *
 * @param {number} ms - The delay time (in milliseconds) before executing the callback.
 * @param {function} callback - The function to be executed after the specified delay.
 */
function setTimeout(ms, callback) {
  let t = new Thread(function() {
    Thread.sleep(ms);
    callback();
  });

  t.start();
}