/**
 * Format the time in "HH:MM" format
 * @param ms {number} Time in milliseconds (if this value is null, then will be current time)
 * @return {string} The time in HH:MM format
*/
function formatTime(ms) {
    let millis;
    if (ms) {
        millis = ms;
    } else {
        millis = Date.now()
    }

    const now = new Date(millis)
    const hh = String(now.getHours()).padStart(2, "0");
    const mm = String(now.getMinutes()).padStart(2, "0");
    return `${hh}:${mm}`;
}