/**
 * Get the closest platform from the model coords
 * @param {mtr.data.ClientData} ClientData - ClientData from the Minecraft Transit Railway.
 * @param {cn.zbx1425.sowcer.math.Vector3f} modelVector3f - Vector3f from the MTR-NTE mod.
 * @throws {Error} If ClientData and/or modelVector3f are null
 * @return {{closestPlatform: mtr.data.Platform|null, distanceRaw: number|null}|null} 
 *         The closest platform from the model and the squared distance, or null if no platforms exist.
 */
function getClosestPlatfrom(ClientData, modelVector3f) {
  if (!ClientData) {
    throw new Error("You must add the MTR Client Data");
  }

  if (!modelVector3f) {
    throw new Error("You must give the model's Vector3f");
  }

  if (ClientData.PLATFORMS.size() === 0) {
    return null
  }

  const res = {
    closestPlatform: null,
    distanceRaw: null
  };

  let minDistSq = Number.MAX_VALUE;
  for (let platform of ClientData.PLATFORMS) {
    let chosenPlatform = new Vector3f(platform.getMidPos());
    let distSq = modelVector3f.distanceSq(chosenPlatform);

    if (distSq < minDistSq) {
      minDistSq = distSq;
      res.closestPlatform = platform;
      res.distanceRaw = distSq;
    }
  }

  return res;
}