/**
 * Get the closest station from the model coords, optionally filtering by station name.
 * @param {mtr.client.ClientData} ClientData - ClientData from the Minecraft Transit Railway.
 * @param {number} platformId - The platform ID to search for.
 * @throws {Error} If ClientData and/or platformId are null.
 * @return {Array<mtr.data.ScheduleEntry>} An array with the next departures; empty if none found.
 */
function getDepartures(ClientData, platformId) {
  if (!ClientData) {
    throw new Error("You must add the MTR Client Data");
  }

  if (!platformId) {
    throw new Error("You must set a valid platformId to search");
  }

  const departures = [];
  let platform = new Packages.java.lang.Long(platformId);
  let departuresSet = ClientData.SCHEDULES_FOR_PLATFORM.get(platform);
  for (let departure of departuresSet) {
    departures.push({
      arrivalMillis: Number(departure.arrivalMillis),
      trainCars: Number(departure.trainCars),
      routeId: Number(departure.routeId),
      currentStationIndex: Number(departure.currentStationIndex)
    });
  }

  return departures.sort((a, b) => a.arrivalMillis - b.arrivalMillis);
}