/**
 * Get the routes where the specified platform stops.
 * @param {mtr.data.ClientData} ClientData - ClientData from the Minecraft Transit Railway.
 * @param {mtr.data.Station} Station - Station from the Minecraft Transit Railway.
 * @throws {Error} If ClientData is null or Station is not provided.
 * @return {Array<mtr.data.Platform>} An array of Platform objects where the platform is inside the station; empty if none found.
 */
function getPlatformsFromStation(ClientData, Station) {
  if (!ClientData) {
    throw new Error("You must add the MTR Client Data");
  }

  if (!Station) {
    throw new Error("You must add an Station");
  }

  const platformInStation = [];
  for (let platform of ClientData.PLATFORMS) {
    let platformCoords = new Vector3f(platform.getMidPos());
    if (Station.inArea(platformCoords.x(), platformCoords.z())) {
      platformInStation.push(platform);
    }
  }

  return platformInStation;
}