/**
 * Convert arrival in milliseconds to minutes
 * @param arrivalTime {number} - Time of arrival in milliseconds
 * 
 * @return {number} A number with minutes left (0 for less than one minute)
 * */
function getRemainingMinutes(arrivalTime) {
  const millis = Number(arrivalTime);

  if (isNaN(millis)) {
    print(`JOANNET NEUE > Not a number! Type is ${typeof arrivalTime} and value is '${arrivalTime}'. Returning 0.`);
    return 0;
  } else {
    return Math.floor((millis - Date.now()) / 60000);
  }
}