/**
 * Get the routes where the specified platform stops.
 * @param {mtr.client.ClientData} ClientData - ClientData from the Minecraft Transit Railway.
 * @param {number} platformId - The platform ID to search for.
 * @throws {Error} If ClientData is null or platformId is not provided.
 * @return {Array<mtr.data.Route>} An array of Route objects where the platform stops; empty if none found.
 */
function getRoutesFromPlatform(ClientData, platformId) {
  if (!ClientData) {
    throw new Error("You must add the MTR Client Data");
  }

  if (typeof platformId === 'number') {
    throw new Error("You must set a valid platformId to search");
  }

  const stoppingRoutes = [];
  for (let route of ClientData.ROUTES) {
    for (let i = 0; i < route.platformIds.size(); i++) {
      let routePlatform = route.platformIds.get(i);

      if (routePlatform.platformId === platformId) {
        stoppingRoutes.push(route);
        break;
      }
    }
  }

  return stoppingRoutes;
}