/**
 * Get the station data where the model is located based on its coordinates.
 * @param {mtr.data.ClientData} ClientData - ClientData from the Minecraft Transit Railway.
 * @param {cn.zbx1425.sowcer.math.Vector3f} modelVector3f - Vector3f from the MTR-NTE mod.
 * @throws {Error} If ClientData and/or modelVector3f are null.
 * @return {mtr.data.Station|null} The station where the model is located. Returns null if none is found or model is not in any station zone.
 */
function getStationInArea(ClientData, modelVector3f) {
  if (!ClientData) {
    throw new Error("You must add the MTR Client Data");
  }

  if (!modelVector3f) {
    throw new Error("You must give the model's Vector3f");
  }

  if (ClientData.STATIONS.size() === 0) {
    return null
  }

  for (let station of ClientData.STATIONS) {
    if (station.inArea(modelVector3f.x(), modelVector3f.z())) {
      return station || null;
      break;
    }
  }
}