/**
 * Draws a string centered horizontally so that the center of the text is at (x, y).
 * Works like ctx.drawString, but centers the string horizontally around x.
 *
 * @param {java.awt.Graphics2D} ctx the Graphics2D context
 * @param {string}              str the string to draw
 * @param {number}              x   the x‑coordinate where the center of the text should be
 * @param {number}              y   the y‑coordinate of the text baseline
 */
function drawCenteredString(ctx, str, x, y) {
    var fm = ctx.getFontMetrics();
    var textWidth = fm.stringWidth(str);
    ctx.drawString(str, x - textWidth / 2, y);
}