/**
 * Draws a right‑aligned string so that its right edge is at (x, y).
 * Works like ctx.drawString, but aligns the string to the right edge instead of the left.
 *
 * @param {java.awt.Graphics2D} ctx the Graphics2D context
 * @param {string}              str the string to draw
 * @param {number}              x   the x‑coordinate where the string’s right edge should land
 * @param {number}              y   the y‑coordinate of the text baseline
 */
function drawRightAlignedString(ctx, str, x, y) {
    var fm = ctx.getFontMetrics();
    var textWidth = fm.stringWidth(str);
    ctx.drawString(str, x - textWidth, y);
}
