/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.commands;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LinkedHeartCommand
implements CommandExecutor {
    private final MinecraftHelden plugin;

    public LinkedHeartCommand(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Msg.send(sender, "&cNur ingame.");
            return true;
        }
        if (!this.plugin.isLinkedHeartEnabled()) {
            Msg.send(sender, "&cLinkedHeart ist derzeit deaktiviert.");
            return true;
        }
        Player player = (Player)sender;
        UUID self = player.getUniqueId();
        int lives = this.plugin.lives().getLives(self);
        if (lives > 0) {
            Msg.send((CommandSender)player, "&eDu hast noch &a" + lives + " &eHerzen. Dein Linked-Partner wird erst bei &f0 &eangezeigt.");
            return true;
        }
        UUID partner = this.plugin.linkedHearts().getPartner(self);
        if (partner == null) {
            Msg.send((CommandSender)player, "&6\u2665 &7&lNoch nicht aktiv");
            return true;
        }
        OfflinePlayer offlinePartner = Bukkit.getOfflinePlayer((UUID)partner);
        String partnerName = offlinePartner != null && offlinePartner.getName() != null ? offlinePartner.getName() : partner.toString();
        Msg.send((CommandSender)player, "&aDein Linked-Partner ist: &6\u2665 &7&l" + partnerName);
        return true;
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

