/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.extras;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.storage.LivesStore;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class Relive
implements Listener {
    private final MinecraftHelden plugin;
    private final LivesStore lives;
    private final HashMap<UUID, Integer> points = new HashMap();

    public Relive(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.lives = plugin.getLivesStore();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private boolean enabled() {
        return this.plugin.getConfig().getBoolean("relive.enabled", false);
    }

    private boolean auto() {
        return this.plugin.getConfig().getBoolean("relive.auto", true);
    }

    private int need() {
        return this.plugin.getConfig().getInt("relive.pointsNeeded", 5);
    }

    @EventHandler
    public void onKill(PlayerDeathEvent e) {
        if (!this.enabled()) {
            return;
        }
        if (e.getEntity().getKiller() == null) {
            return;
        }
        Player p = e.getEntity().getKiller();
        UUID id = p.getUniqueId();
        int current = this.points.getOrDefault(id, 0) + 1;
        this.points.put(id, current);
        if (!this.auto()) {
            return;
        }
        if (current < this.need()) {
            return;
        }
        int livesNow = this.lives.getLives(id);
        int max = this.plugin.getConfig().getInt("maxLives", 3);
        this.points.put(id, current - this.need());
        if (livesNow >= max) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Du hast genug Punkte, aber bereits maximale Leben. Punkte wurden abgezogen.");
            return;
        }
        this.lives.addLives(id, 1);
        p.sendMessage(String.valueOf(ChatColor.GREEN) + "Du erh\u00e4ltst ein Leben.");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("relive")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (!this.enabled()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Relive ist deaktiviert.");
            return true;
        }
        if (this.auto()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Relive funktioniert automatisch und ben\u00f6tigt keinen Command.");
            return true;
        }
        UUID id = p.getUniqueId();
        int current = this.points.getOrDefault(id, 0);
        if (current < this.need()) {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Du hast " + current + "/" + this.need() + " Punkte.");
            return true;
        }
        int livesNow = this.lives.getLives(id);
        int max = this.plugin.getConfig().getInt("maxLives", 3);
        this.points.put(id, current - this.need());
        if (livesNow >= max) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Du hast genug Punkte, aber bereits maximale Leben. Punkte wurden abgezogen.");
            return true;
        }
        this.lives.addLives(id, 1);
        p.sendMessage(String.valueOf(ChatColor.GREEN) + "Du erh\u00e4ltst ein Leben.");
        return true;
    }
}

