/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class CombatListener
implements Listener {
    private final MinecraftHelden plugin;

    public CombatListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Player attacker = null;
        Entity damager = e.getDamager();
        if (damager instanceof Player) {
            Player player2;
            Player player = attacker = (player2 = (Player)damager);
        } else {
            Projectile proj;
            ProjectileSource shooter;
            Entity damager2 = e.getDamager();
            if (damager2 instanceof Projectile && (shooter = (proj = (Projectile)damager2).getShooter()) instanceof Player) {
                Player player;
                Player player2 = attacker = (player = (Player)shooter);
            }
        }
        if (attacker == null) {
            return;
        }
        if (!this.plugin.combat().isPvPEnabled()) {
            e.setCancelled(true);
            return;
        }
        this.plugin.combat().startOrRefreshCombat(attacker, victim);
        this.plugin.combat().maybeNotifyOncePerMinute(attacker.getUniqueId(), "&7Du hast &a" + victim.getName() + " &7angegriffen!");
        this.plugin.combat().maybeNotifyOncePerMinute(victim.getUniqueId(), "&7Du wurdest von &c" + attacker.getName() + " &7angegriffen!");
    }

    @EventHandler
    public void onPearlLaunch(ProjectileLaunchEvent e) {
        if (!(e.getEntity() instanceof EnderPearl)) {
            return;
        }
        ProjectileSource shooter = e.getEntity().getShooter();
        if (!(shooter instanceof Player)) {
            return;
        }
        Player p = (Player)shooter;
        UUID id = p.getUniqueId();
        if (!this.plugin.combat().isInCombat(id)) {
            return;
        }
        if (this.plugin.combat().overPearlLimit(id)) {
            e.setCancelled(true);
            Msg.send((CommandSender)p, "&cDu kannst im Kampf keine Enderpearls mehr werfen (&fLimit: 16&c).");
            return;
        }
        int remaining = this.plugin.combat().tryConsumePearl(id);
        if (remaining >= 0) {
            Msg.send((CommandSender)p, "&eDu hast noch &f" + remaining + " &eEnderpearls \u00fcbrig.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player victim = e.getEntity();
        Player killer = victim.getKiller();
        this.plugin.combat().endCombat(victim.getUniqueId(), false);
        if (killer != null) {
            this.plugin.combat().endCombat(killer.getUniqueId(), false);
        }
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

