/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CombatManager {
    private final MinecraftHelden plugin;
    private final Map<UUID, Long> combatUntil;
    private final Map<UUID, UUID> lastAttacker;
    private final Map<UUID, Long> lastAttackMsg;
    private final Set<UUID> wasInCombat;
    private final Set<UUID> inCombatLogged;
    private boolean pvpEnabled;
    private BukkitTask barTask;
    private final Map<UUID, Integer> pearlsUsed;
    private int maxPearls;
    private long combatDurationMs;

    public CombatManager(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.combatUntil = new HashMap<UUID, Long>();
        this.lastAttacker = new HashMap<UUID, UUID>();
        this.lastAttackMsg = new HashMap<UUID, Long>();
        this.wasInCombat = new HashSet<UUID>();
        this.inCombatLogged = new HashSet<UUID>();
        this.pearlsUsed = new HashMap<UUID, Integer>();
        this.pvpEnabled = true;
        this.maxPearls = plugin.getConfig().getInt("max-enderpearls-per-combat", 32);
        int durationSeconds = plugin.getConfig().getInt("combatduration", 30);
        this.combatDurationMs = (long)durationSeconds * 1000L;
    }

    public void start() {
        this.stop();
        this.barTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            for (Player p : Bukkit.getOnlinePlayers()) {
                UUID id = p.getUniqueId();
                Long until = this.combatUntil.get(id);
                if (until != null && until > now) {
                    this.wasInCombat.add(id);
                    long secs = (until - now) / 1000L;
                    p.sendActionBar(Msg.comp("&cIm Kampf! &7(" + secs + " s \u00fcbrig)"));
                    continue;
                }
                if (!this.wasInCombat.remove(id)) continue;
                this.clearCombat(id, true);
            }
        }, 20L, 20L);
    }

    public void stop() {
        if (this.barTask != null) {
            this.barTask.cancel();
            this.barTask = null;
        }
    }

    public void shutdown() {
        this.stop();
        this.combatUntil.clear();
        this.lastAttacker.clear();
        this.lastAttackMsg.clear();
        this.wasInCombat.clear();
        this.inCombatLogged.clear();
        this.pearlsUsed.clear();
    }

    public void endCombat(UUID id, boolean notify) {
        this.clearCombat(id, notify);
    }

    public void setPvPEnabled(boolean enabled, CommandSender actor) {
        if (this.pvpEnabled == enabled) {
            if (actor != null) {
                actor.sendMessage((Component)Component.text((String)(enabled ? "\u00a7ePvP ist bereits \u00a7aaktiv\u00a7e." : "\u00a7ePvP ist bereits \u00a7cdeaktiviert\u00a7e.")));
            }
            return;
        }
        this.pvpEnabled = enabled;
        String actorName = actor != null ? actor.getName() : "Konsole";
        String msg = enabled ? "&eDas PvP wurde von &a" + actorName + " &ewieder aktiviert!" : "&eDas PvP wurde von &c" + actorName + " &edeaktiviert!";
        Bukkit.getServer().broadcast(Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] " + msg));
        Sound s = enabled ? Sound.sound((Key)Key.key((String)"minecraft:block.note_block.pling"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.6f) : Sound.sound((Key)Key.key((String)"minecraft:block.anvil.land"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)0.6f);
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.playSound(s);
        }
    }

    public boolean isPvPEnabled() {
        return this.pvpEnabled;
    }

    public boolean isInCombat(UUID id) {
        Long until = this.combatUntil.get(id);
        return until != null && until > System.currentTimeMillis();
    }

    public void maybeNotifyOncePerMinute(UUID playerId, String msg) {
        long now = System.currentTimeMillis();
        Long last = this.lastAttackMsg.get(playerId);
        if (last == null || now - last >= 60000L) {
            this.lastAttackMsg.put(playerId, now);
            Player p = Bukkit.getPlayer((UUID)playerId);
            if (p != null) {
                p.sendMessage(Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] " + msg));
            }
        }
    }

    public String remainingSeconds(UUID id) {
        long until = this.combatUntil.getOrDefault(id, 0L);
        long diff = until - System.currentTimeMillis();
        return diff <= 0L ? "0" : String.valueOf(diff / 1000L);
    }

    public UUID getLastAttacker(UUID id) {
        return this.lastAttacker.get(id);
    }

    public void clearCombat(UUID id, boolean notify) {
        Player p;
        boolean was = this.isInCombat(id);
        this.combatUntil.remove(id);
        this.wasInCombat.remove(id);
        this.lastAttacker.remove(id);
        this.lastAttackMsg.remove(id);
        this.pearlsUsed.remove(id);
        if (notify && (p = Bukkit.getPlayer((UUID)id)) != null) {
            p.sendMessage(Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] &aDu bist wieder sicher. Der Kampf ist vorbei!"));
        }
    }

    public boolean overPearlLimit(UUID id) {
        return this.isInCombat(id) && this.pearlsUsed.getOrDefault(id, 0) >= this.maxPearls;
    }

    public int tryConsumePearl(UUID id) {
        if (!this.isInCombat(id)) {
            return -1;
        }
        int used = this.pearlsUsed.getOrDefault(id, 0);
        if (used >= this.maxPearls) {
            return -1;
        }
        this.pearlsUsed.put(id, ++used);
        return this.maxPearls - used;
    }

    private void logEnter(UUID id) {
        if (this.plugin.discord() == null) {
            return;
        }
        if (!this.inCombatLogged.add(id)) {
            return;
        }
        Player p = Bukkit.getPlayer((UUID)id);
        if (p != null) {
            long until = this.combatUntil.getOrDefault(id, 0L);
            int secs = (int)Math.max(0L, (until - System.currentTimeMillis()) / 1000L);
            this.plugin.discord().combatEnter(p.getName(), secs);
        }
    }

    private void logExit(UUID id, String reason) {
        if (this.plugin.discord() == null) {
            return;
        }
        if (!this.inCombatLogged.remove(id)) {
            return;
        }
        Player p = Bukkit.getPlayer((UUID)id);
        if (p != null) {
            this.plugin.discord().combatExit(p.getName(), reason == null ? "" : reason);
        }
    }

    public void startOrRefreshCombat(Player attacker, Player victim) {
        long now = System.currentTimeMillis();
        long until = now + this.combatDurationMs;
        this.combatUntil.put(attacker.getUniqueId(), until);
        this.combatUntil.put(victim.getUniqueId(), until);
        this.lastAttacker.put(victim.getUniqueId(), attacker.getUniqueId());
        this.wasInCombat.add(attacker.getUniqueId());
        this.wasInCombat.add(victim.getUniqueId());
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

