/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GlowManager {
    private final MinecraftHelden plugin;
    private final long intervalTicks;
    private final int durationSeconds;
    private final boolean loseHeartOnLogout;
    private boolean glowingEnabled;
    private final Map<UUID, BukkitRunnable> activeGlows = new HashMap<UUID, BukkitRunnable>();

    public GlowManager(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.glowingEnabled = plugin.getConfig().getBoolean("glowing", true);
        this.intervalTicks = plugin.getConfig().getLong("glow-interval-minutes", 20L) * 60L * 20L;
        this.durationSeconds = plugin.getConfig().getInt("glow-duration-seconds", 60);
        this.loseHeartOnLogout = plugin.getConfig().getBoolean("glow-lose-heart-on-logout", true);
        if (this.glowingEnabled) {
            this.startGlowCycle();
        }
    }

    private void startGlowCycle() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (GlowManager.this.plugin.combat().isInCombat(player.getUniqueId())) continue;
                    GlowManager.this.startGlow(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, this.intervalTicks);
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    private void startGlow(final Player player) {
        final UUID id = player.getUniqueId();
        if (this.activeGlows.containsKey(id)) {
            return;
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, this.durationSeconds * 20, 0, false, false, true));
        Msg.send((CommandSender)player, "&eDu leuchtest nun f\u00fcr &f" + this.durationSeconds + " Sekunden!");
        BukkitRunnable task = new BukkitRunnable(){
            int timeLeft;
            {
                this.timeLeft = GlowManager.this.durationSeconds;
            }

            public void run() {
                if (!player.isOnline() || GlowManager.this.plugin.combat().isInCombat(id)) {
                    GlowManager.this.removeGlow(player);
                    this.cancel();
                    return;
                }
                --this.timeLeft;
                if (this.timeLeft <= 0) {
                    GlowManager.this.removeGlow(player);
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)this.plugin, 20L, 20L);
        this.activeGlows.put(id, task);
    }

    public void removeGlow(Player player) {
        UUID id = player.getUniqueId();
        player.removePotionEffect(PotionEffectType.GLOWING);
        Msg.send((CommandSender)player, "&7Dein &eGlow &7ist nun vorbei.");
        BukkitRunnable task = this.activeGlows.remove(id);
        if (task != null) {
            task.cancel();
        }
    }

    public void handleLogout(Player player) {
        UUID id = player.getUniqueId();
        if (this.activeGlows.containsKey(id)) {
            this.removeGlow(player);
            if (this.loseHeartOnLogout) {
                int lives = this.plugin.lives().getLives(id);
                this.plugin.lives().setLives(id, Math.max(0, lives - 1));
                Msg.send((CommandSender)player, "&cDu hast beim Ausloggen ein &4\u2764 &cverloren!");
            }
        }
    }
}

