/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.utils;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public final class Msg {
    private static final LegacyComponentSerializer LEGACY;
    private static String PREFIX_RAW;

    private Msg() {
    }

    public static String color(String s) {
        return s == null ? "" : s.replace('&', '\u00a7');
    }

    public static String withPrefix(String s) {
        return Msg.color(PREFIX_RAW + s);
    }

    public static void send(CommandSender to, String s) {
        to.sendMessage(Msg.withPrefix(s));
    }

    public static Component comp(String s) {
        return LEGACY.deserialize(Msg.color(s));
    }

    public static void loadPrefix(MinecraftHelden plugin) {
        boolean customEnabled = plugin.getConfig().getBoolean("prefix.custom.enabled", false);
        String custom = plugin.getConfig().getString("prefix.custom.custom", "&6[Helden]");
        if (customEnabled) {
            PREFIX_RAW = custom + " ";
            plugin.getLogger().info("Custom Prefix aktiviert: " + PREFIX_RAW);
            return;
        }
        String cling = plugin.getConfig().getString("prefix.cling", "&f");
        String text = plugin.getConfig().getString("prefix.text", "&6&l");
        PREFIX_RAW = cling + "[" + text + "Helden" + cling + "] ";
        plugin.getLogger().info("Standard Prefix gesetzt: " + PREFIX_RAW);
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    static {
        PREFIX_RAW = "&f[&6Helden&f] ";
        LEGACY = LegacyComponentSerializer.legacy((char)'&');
    }
}

