/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class EnderPearlManager {
    private final CombatPlugin plugin;
    private final Map<UUID, Integer> usedPearls = new HashMap<UUID, Integer>();
    private final int maxPearls;

    public EnderPearlManager(CombatPlugin plugin) {
        this.plugin = plugin;
        this.maxPearls = plugin.getConfig().getInt("max-enderpearls-per-combat", 32);
    }

    public boolean canUseEnderPearl(Player player) {
        if (!this.plugin.getCombatManager().isInCombat(player.getUniqueId())) {
            return true;
        }
        int used = this.usedPearls.getOrDefault(player.getUniqueId(), 0);
        return used < this.maxPearls;
    }

    public void recordEnderPearlUse(Player player) {
        if (!this.plugin.getCombatManager().isInCombat(player.getUniqueId())) {
            return;
        }
        UUID uuid = player.getUniqueId();
        this.usedPearls.put(uuid, this.usedPearls.getOrDefault(uuid, 0) + 1);
    }

    public void resetEnderPearls(UUID uuid) {
        this.usedPearls.remove(uuid);
    }

    public int getUsedPearls(Player player) {
        return this.usedPearls.getOrDefault(player.getUniqueId(), 0);
    }

    public int getMaxPearls() {
        return this.maxPearls;
    }
}

