/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatPlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LivesCommand
implements CommandExecutor {
    private final CombatPlugin plugin;

    public LivesCommand(CombatPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Nur Spieler k\u00f6nnen diesen Befehl verwenden.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("heroes.lives")) {
            this.plugin.sendMessage(player, "Du hast keine Berechtigung, diesen Befehl zu verwenden.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.sendMessage(player, "Verwendung: /lives <check|add|set> <player> [amount]");
            return false;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("check")) {
            if (args.length < 2) {
                this.plugin.sendMessage(player, "Verwendung: /lives check <player>");
                return false;
            }
            String targetPlayerName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                this.plugin.sendMessage(player, "Spieler " + targetPlayerName + " ist nicht online oder existiert nicht.");
                return true;
            }
            int lives = this.plugin.getLives(target.getUniqueId());
            this.plugin.sendMessage(player, "Der Spieler " + targetPlayerName + " hat " + lives + " Leben.");
        } else if (subCommand.equals("add")) {
            int amount;
            if (args.length < 3) {
                this.plugin.sendMessage(player, "Verwendung: /lives add <player> <amount>");
                return false;
            }
            String targetPlayerName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                this.plugin.sendMessage(player, "Spieler " + targetPlayerName + " ist nicht online oder existiert nicht.");
                return true;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                this.plugin.sendMessage(player, "Die Menge muss eine Zahl sein.");
                return true;
            }
            int newLives = this.plugin.getLives(target.getUniqueId()) + amount;
            this.plugin.setLives(target.getUniqueId(), newLives);
            this.plugin.sendMessage(player, "Du hast " + amount + " Leben zu " + targetPlayerName + " hinzugef\u00fcgt. Neuer Wert: " + newLives);
        } else if (subCommand.equals("set")) {
            int amount;
            if (args.length < 3) {
                this.plugin.sendMessage(player, "Verwendung: /lives set <player> <amount>");
                return false;
            }
            String targetPlayerName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                this.plugin.sendMessage(player, "Spieler " + targetPlayerName + " ist nicht online oder existiert nicht.");
                return true;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                this.plugin.sendMessage(player, "Die Menge muss eine Zahl sein.");
                return true;
            }
            this.plugin.setLives(target.getUniqueId(), amount);
            this.plugin.sendMessage(player, "Du hast die Leben von " + targetPlayerName + " auf " + amount + " gesetzt.");
        } else {
            this.plugin.sendMessage(player, "Ung\u00fcltiger Sub-Befehl. Verf\u00fcgbare Befehle: check, add, set.");
        }
        return true;
    }
}

