/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatPlugin;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class NoNetheriteListener
implements Listener {
    private final CombatPlugin plugin;

    public NoNetheriteListener(CombatPlugin plugin) {
        this.plugin = plugin;
    }

    private boolean isNetheriteArmor(Material material) {
        return material == Material.NETHERITE_HELMET || material == Material.NETHERITE_CHESTPLATE || material == Material.NETHERITE_LEGGINGS || material == Material.NETHERITE_BOOTS;
    }

    private boolean isNetheriteMaterial(Material material) {
        return material == Material.NETHERITE_SWORD || material == Material.NETHERITE_AXE || material == Material.NETHERITE_PICKAXE || material == Material.NETHERITE_SHOVEL || material == Material.NETHERITE_HOE || this.isNetheriteArmor(material);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.plugin.isNoNetherite()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int rawSlot = event.getRawSlot();
        if (rawSlot >= 5 && rawSlot <= 8) {
            ItemStack currentItem = event.getCurrentItem();
            ItemStack cursorItem = event.getCursor();
            if (cursorItem != null && this.isNetheriteArmor(cursorItem.getType()) || currentItem != null && this.isNetheriteArmor(currentItem.getType())) {
                event.setCancelled(true);
                this.plugin.sendMessage(player, String.valueOf(ChatColor.RED) + "Netherite-R\u00fcstung darf hier nicht abgelegt werden!");
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.isNoNetherite()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && this.isNetheriteArmor(item.getType()) && event.getHand() == EquipmentSlot.HAND) {
            event.setCancelled(true);
            this.plugin.sendMessage(player, String.valueOf(ChatColor.RED) + "Das Anlegen von Netherite-R\u00fcstung ist deaktiviert!");
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.isNoNetherite()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && this.isNetheriteMaterial(item.getType())) {
            event.setCancelled(true);
            this.plugin.sendMessage(player, String.valueOf(ChatColor.RED) + "Das Benutzen von Netherite-Werkzeugen ist deaktiviert!");
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.plugin.isNoNetherite()) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && this.isNetheriteMaterial(item.getType())) {
            event.setCancelled(true);
            this.plugin.sendMessage(player, String.valueOf(ChatColor.RED) + "Das Benutzen von Netherite-Waffen ist deaktiviert!");
        }
    }

    @EventHandler
    public void onBlockDispenseArmor(BlockDispenseArmorEvent event) {
        ItemStack armor;
        if (!this.plugin.isNoNetherite()) {
            return;
        }
        LivingEntity target = event.getTargetEntity();
        if (target instanceof Player && (armor = event.getItem()) != null && this.isNetheriteArmor(armor.getType())) {
            event.setCancelled(true);
            this.plugin.sendMessage((Player)target, String.valueOf(ChatColor.RED) + "Dispenser k\u00f6nnen keine Netherite-R\u00fcstung anlegen!");
        }
    }
}

