/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes.commands;

import de.scholle.minecraftheroes.CombatManager;
import de.scholle.minecraftheroes.CombatPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DuelCommand
implements CommandExecutor {
    private final CombatPlugin plugin;
    private final CombatManager combatManager;
    private final Map<UUID, UUID> duelRequests = new HashMap<UUID, UUID>();

    public DuelCommand(CombatPlugin plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cNur Spieler k\u00f6nnen Duelle starten.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("accept")) {
            UUID requesterUuid = this.duelRequests.remove(player.getUniqueId());
            if (requesterUuid == null) {
                player.sendMessage("\u00a7cDu hast keine Duellanfrage zum Akzeptieren.");
                return true;
            }
            Player requester = Bukkit.getPlayer((UUID)requesterUuid);
            if (requester == null || !requester.isOnline()) {
                player.sendMessage("\u00a7cDer Spieler ist nicht mehr online.");
                return true;
            }
            this.combatManager.startDuel(requester, player);
            return true;
        }
        if (args.length == 1) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendMessage("\u00a7cSpieler nicht gefunden oder offline.");
                return true;
            }
            if (player.equals((Object)target)) {
                player.sendMessage("\u00a7cDu kannst kein Duell mit dir selbst starten.");
                return true;
            }
            this.duelRequests.put(target.getUniqueId(), player.getUniqueId());
            player.sendMessage("\u00a7aDuellanfrage an " + target.getName() + " gesendet!");
            target.sendMessage("\u00a7e" + player.getName() + " m\u00f6chte ein Duell mit dir starten. Tippe \u00a7a/duel accept\u00a7e zum Akzeptieren.");
            return true;
        }
        player.sendMessage("\u00a7cBenutzung: /duel <Spieler> | /duel accept");
        return true;
    }
}

