/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatManager;
import de.scholle.minecraftheroes.CombatPlugin;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class CombatLogoutListener
implements Listener {
    private final CombatPlugin plugin;

    public CombatLogoutListener(CombatPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.plugin.isLoseLifeOnLogoutDuringCombatEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.plugin.getCombatManager().isInCombat(uuid)) {
            int currentLives = this.plugin.getLives(uuid);
            int newLives = currentLives - 1;
            if (newLives <= 0) {
                this.plugin.removePlayer(uuid);
                Bukkit.getLogger().info(this.plugin.getLanguage().getMessage("combat.logout.lost_all_lives").replace("%player%", player.getName()));
            } else {
                this.plugin.setLives(uuid, newLives);
                Bukkit.getLogger().info(this.plugin.getLanguage().getMessage("combat.logout.lost_one_life").replace("%player%", player.getName()).replace("%lives%", String.valueOf(newLives)));
            }
            CombatManager cm = this.plugin.getCombatManager();
            UUID opponent = cm.getOpponent(uuid);
            cm.resetCombat(uuid);
            if (opponent != null) {
                cm.resetCombat(opponent);
            }
        }
    }
}

