/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private final JavaPlugin plugin;
    private Map<String, String> messages = new HashMap<String, String>();

    public LanguageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadLanguage("de_de");
    }

    public void loadLanguage(String langCode) {
        File langFile;
        block22: {
            File langFolder = new File(this.plugin.getDataFolder(), "lang");
            if (!langFolder.exists()) {
                langFolder.mkdirs();
            }
            if (!(langFile = new File(langFolder, langCode + ".json")).exists()) {
                try (InputStream in = this.plugin.getResource("lang/" + langCode + ".json");){
                    if (in == null) break block22;
                    try (FileOutputStream out = new FileOutputStream(langFile);){
                        in.transferTo(out);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(langFile), StandardCharsets.UTF_8);){
            Type type = new TypeToken<Map<String, String>>(this){}.getType();
            this.messages = (Map)new Gson().fromJson((Reader)reader, type);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Konnte Sprachdatei nicht laden: " + e.getMessage());
        }
    }

    public String getMessage(String key) {
        return this.get(key, null);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        return this.get(key, placeholders);
    }

    public String get(String key, Map<String, String> placeholders) {
        String msg = this.messages.getOrDefault(key, key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return msg;
    }

    public String get(String key) {
        return this.get(key, null);
    }
}

