/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes.dummy;

import de.scholle.minecraftheroes.CombatPlugin;
import de.scholle.minecraftheroes.dummy.DummyData;
import de.scholle.minecraftheroes.dummy.DummyManager;
import java.util.UUID;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class DummyListener
implements Listener {
    private final CombatPlugin plugin;

    public DummyListener(CombatPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getConfig().getBoolean("dummy.enabled")) {
            return;
        }
        DummyManager.spawnDummy(player);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        DummyManager.onPlayerJoin(player.getUniqueId(), player);
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        Entity victim = event.getEntity();
        if (!(victim instanceof ArmorStand)) {
            return;
        }
        UUID owner = DummyManager.getOwner(victim);
        if (owner == null) {
            return;
        }
        DummyData data = DummyManager.getDummy(owner);
        if (data == null) {
            return;
        }
        double damage = event.getDamage();
        double newHealth = data.getDummy().getHealth() - damage;
        if (newHealth <= 0.0) {
            DummyManager.killDummy(owner);
        } else {
            data.getDummy().setHealth(newHealth);
            DummyManager.resetDespawnTimer(owner);
        }
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player damager = (Player)entity;
            this.plugin.getCombatManager().getCombatTimestamps().put(damager.getUniqueId(), System.currentTimeMillis());
            this.plugin.getCombatManager().getCombatTimestamps().put(owner, System.currentTimeMillis());
        }
    }
}

