/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatManager;
import de.scholle.minecraftheroes.CombatPlugin;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatDisplayManager {
    private final CombatPlugin plugin;
    private final CombatManager combatManager;
    private static final String HEART_1 = "\ue003";
    private static final String HEART_2 = "\ue002";
    private static final String HEART_3 = "\ue001";

    public CombatDisplayManager(CombatPlugin plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
        this.startDisplayTask();
    }

    private void startDisplayTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getGameMode() == GameMode.SPECTATOR) {
                        player.sendActionBar((Component)Component.empty());
                        continue;
                    }
                    UUID uuid = player.getUniqueId();
                    if (CombatDisplayManager.this.combatManager.isInCombat(uuid)) {
                        int secondsLeft = CombatDisplayManager.this.combatManager.getCombatTimeLeft(uuid);
                        String combatText = CombatDisplayManager.this.plugin.getLanguage().getMessage("combat.actionbar").replace("%seconds%", String.valueOf(secondsLeft));
                        TextComponent combatTimeText = Component.text((String)combatText, (TextColor)NamedTextColor.RED);
                        player.sendActionBar((Component)combatTimeText);
                        continue;
                    }
                    int lives = CombatDisplayManager.this.plugin.getLives(uuid);
                    player.sendActionBar((Component)Component.text((String)(switch (lives) {
                        case 1 -> CombatDisplayManager.HEART_1;
                        case 2 -> CombatDisplayManager.HEART_2;
                        case 3 -> CombatDisplayManager.HEART_3;
                        default -> "";
                    })));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }
}

