/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatManager
implements Listener {
    private final CombatPlugin plugin;
    private final Map<UUID, Long> combatTimestamps = new HashMap<UUID, Long>();
    private final Map<UUID, UUID> lastCombatOpponent = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> activeDuels = new HashMap<UUID, UUID>();
    private final long combatDurationMs;

    public CombatManager(CombatPlugin plugin) {
        this.plugin = plugin;
        int seconds = plugin.getConfig().getInt("combat-duration-seconds", 30);
        this.combatDurationMs = (long)seconds * 1000L;
    }

    private void enterCombat(Player a, Player b) {
        long now = System.currentTimeMillis();
        boolean aInCombat = this.isInCombat(a.getUniqueId());
        boolean bInCombat = this.isInCombat(b.getUniqueId());
        this.combatTimestamps.put(a.getUniqueId(), now);
        this.combatTimestamps.put(b.getUniqueId(), now);
        this.lastCombatOpponent.put(a.getUniqueId(), b.getUniqueId());
        this.lastCombatOpponent.put(b.getUniqueId(), a.getUniqueId());
        if (!aInCombat) {
            String attackedMsg = this.plugin.getLanguage().get("combat.attacked", Map.of("attacker", b.getName()));
            this.plugin.sendMessage(a, attackedMsg);
        }
        if (!bInCombat) {
            String attackerMsg = this.plugin.getLanguage().get("combat.attacker", Map.of("victim", a.getName()));
            this.plugin.sendMessage(b, attackerMsg);
        }
        this.plugin.getCobwebManager().resetCobwebs(a.getUniqueId());
        this.plugin.getCobwebManager().resetCobwebs(b.getUniqueId());
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damaged = (Player)entity;
        Player damager = null;
        Entity entity2 = event.getDamager();
        if (entity2 instanceof Player) {
            Player p;
            damager = p = (Player)entity2;
        } else {
            entity2 = event.getDamager();
            if (entity2 instanceof Projectile) {
                Projectile projectile = (Projectile)entity2;
                ProjectileSource projectileSource = projectile.getShooter();
                if (projectileSource instanceof Player) {
                    shooter = (Player)projectileSource;
                    damager = shooter;
                }
            } else {
                TNTPrimed tnt;
                shooter = event.getDamager();
                if (shooter instanceof TNTPrimed && (tnt = (TNTPrimed)shooter).hasMetadata("manual")) {
                    String shooterId = ((MetadataValue)tnt.getMetadata("manual").get(0)).asString();
                    damager = Bukkit.getPlayer((UUID)UUID.fromString(shooterId));
                }
            }
        }
        if (damager != null) {
            this.enterCombat(damaged, damager);
        }
    }

    public void markTNTManual(TNTPrimed tnt, Player shooter) {
        tnt.setMetadata("manual", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)shooter.getUniqueId().toString()));
    }

    public boolean isInDuel(UUID uuid) {
        return this.activeDuels.containsKey(uuid);
    }

    public UUID getDuelOpponent(UUID uuid) {
        return this.activeDuels.get(uuid);
    }

    public void startDuel(Player a, Player b) {
        this.activeDuels.put(a.getUniqueId(), b.getUniqueId());
        this.activeDuels.put(b.getUniqueId(), a.getUniqueId());
        this.sendMessage(a, "\u00a7aDuell gestartet mit " + b.getName() + "!");
        this.sendMessage(b, "\u00a7c" + a.getName() + " hat ein Duell mit dir gestartet!");
    }

    public void endDuel(UUID uuid) {
        Player player;
        UUID opponent = this.activeDuels.remove(uuid);
        if (opponent != null) {
            this.activeDuels.remove(opponent);
            Player opp = Bukkit.getPlayer((UUID)opponent);
            if (opp != null && opp.isOnline()) {
                this.sendMessage(opp, "\u00a7eDas Duell wurde beendet!");
            }
        }
        if ((player = Bukkit.getPlayer((UUID)uuid)) != null && player.isOnline()) {
            this.sendMessage(player, "\u00a7eDas Duell wurde beendet!");
        }
    }

    private void sendMessage(Player player, String message) {
        this.plugin.sendMessage(player, message);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDeath(PlayerDeathEvent event) {
        double keepPct;
        final Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        boolean inCombat = now - this.combatTimestamps.getOrDefault(uuid, 0L) <= this.combatDurationMs;
        boolean inDuel = this.isInDuel(uuid);
        double d = keepPct = inCombat ? this.plugin.getKeepInventoryPercentageCombat() : this.plugin.getKeepInventoryPercentageNatural();
        if (!inDuel) {
            if (inCombat) {
                Player opponent;
                int lives = this.plugin.getLives(uuid) - 1;
                UUID oppId = this.getOpponent(uuid);
                Player player2 = opponent = oppId != null ? Bukkit.getPlayer((UUID)oppId) : null;
                if (lives <= 0) {
                    String action;
                    this.plugin.removePlayer(uuid);
                    switch (action = this.plugin.getConfig().getString("player-death-action", "spec").toLowerCase()) {
                        case "ban": {
                            player.kick((Component)Component.text((String)this.plugin.getLanguage().get("combat.death.kick")));
                            Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), "Alle Leben verloren", null, null);
                            break;
                        }
                        case "timeout": {
                            long timeoutSeconds = this.plugin.getConfig().getLong("death-timeout-seconds", 60L);
                            player.setGameMode(GameMode.SPECTATOR);
                            Map<String, String> ph = Map.of("time", String.valueOf(timeoutSeconds));
                            this.plugin.sendMessage(player, this.plugin.getLanguage().get("combat.death.timeout.start", ph));
                            new BukkitRunnable(){

                                public void run() {
                                    if (player.isOnline()) {
                                        player.setGameMode(GameMode.SURVIVAL);
                                        CombatManager.this.plugin.sendMessage(player, CombatManager.this.plugin.getLanguage().get("combat.death.timeout.end"));
                                    }
                                }
                            }.runTaskLater((Plugin)this.plugin, timeoutSeconds * 20L);
                            break;
                        }
                        default: {
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                                this.plugin.sendMessage(player, this.plugin.getLanguage().get("combat.death.none"));
                                player.setGameMode(GameMode.SPECTATOR);
                            }, 2L);
                            break;
                        }
                    }
                } else {
                    this.plugin.setLives(uuid, lives);
                    HashMap<String, String> ph = new HashMap<String, String>();
                    ph.put("victim", player.getName());
                    ph.put("killer", opponent != null ? opponent.getName() : "Unbekannt");
                    String msg = this.plugin.getLanguage().get("combat.death.broadcast", ph);
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        this.plugin.sendMessage(online, msg);
                    }
                    this.plugin.sendMessage(player, this.plugin.getLanguage().get("combat.death.livesleft", Map.of("lives", String.valueOf(lives))));
                }
            }
        } else {
            Player opponent;
            UUID opponentUuid = this.getDuelOpponent(uuid);
            this.endDuel(uuid);
            if (opponentUuid != null && (opponent = Bukkit.getPlayer((UUID)opponentUuid)) != null && opponent.isOnline()) {
                this.sendMessage(opponent, "\u00a7aDu hast das Duell gewonnen, da dein Gegner gestorben ist!");
            }
            this.sendMessage(player, "\u00a7eDu bist im Duell gestorben, daher verlierst du kein Leben.");
        }
        ItemStack[] inventory = player.getInventory().getContents();
        ArrayList<Integer> occupied = new ArrayList<Integer>();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || inventory[i].getType() == Material.AIR) continue;
            occupied.add(i);
        }
        int keepCount = (int)Math.round((double)occupied.size() * keepPct);
        Collections.shuffle(occupied);
        List keepSlots = occupied.subList(0, Math.min(keepCount, occupied.size()));
        ItemStack[] kept = new ItemStack[inventory.length];
        for (int i = 0; i < inventory.length; ++i) {
            if (!keepSlots.contains(i)) continue;
            kept[i] = inventory[i];
        }
        for (Integer slot : keepSlots) {
            player.getInventory().setItem(slot.intValue(), null);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            player.getInventory().setContents(kept);
            this.plugin.sendMessage(player, this.plugin.getLanguage().get("inventory.keep"));
        });
        if (inCombat) {
            this.combatTimestamps.remove(uuid);
            this.lastCombatOpponent.remove(uuid);
        }
        final int frames = this.plugin.getConfig().getInt("death-animation-frames", 10);
        new BukkitRunnable(this){
            int currentFrame = 1;

            public void run() {
                if (this.currentFrame > frames) {
                    this.cancel();
                    return;
                }
                String frameFile = String.format("%03d.png", this.currentFrame);
                ++this.currentFrame;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public boolean isInCombat(UUID uuid) {
        return System.currentTimeMillis() - this.combatTimestamps.getOrDefault(uuid, 0L) <= this.combatDurationMs;
    }

    public UUID getOpponent(UUID uuid) {
        return this.lastCombatOpponent.get(uuid);
    }

    public void resetCombat(UUID uuid) {
        this.combatTimestamps.remove(uuid);
        this.lastCombatOpponent.remove(uuid);
    }

    public Map<UUID, Long> getCombatTimestamps() {
        return this.combatTimestamps;
    }

    public int getCombatTimeLeft(UUID uuid) {
        long now = System.currentTimeMillis();
        long combatTimestamp = this.combatTimestamps.getOrDefault(uuid, 0L);
        long elapsed = now - combatTimestamp;
        int timeLeft = (int)((this.combatDurationMs - elapsed) / 1000L);
        return Math.max(timeLeft, 0);
    }
}

