/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CobwebListener;
import de.scholle.minecraftheroes.CobwebManager;
import de.scholle.minecraftheroes.CombatDisplayManager;
import de.scholle.minecraftheroes.CombatLogoutListener;
import de.scholle.minecraftheroes.CombatManager;
import de.scholle.minecraftheroes.CombatTabCompleter;
import de.scholle.minecraftheroes.EnderPearlListener;
import de.scholle.minecraftheroes.EnderPearlManager;
import de.scholle.minecraftheroes.FireworkCrossbowBlocker;
import de.scholle.minecraftheroes.FireworkUseBlocker;
import de.scholle.minecraftheroes.LanguageManager;
import de.scholle.minecraftheroes.LivesCommand;
import de.scholle.minecraftheroes.LivesStorage;
import de.scholle.minecraftheroes.NetherEnterBlocker;
import de.scholle.minecraftheroes.NoNetheriteListener;
import de.scholle.minecraftheroes.NoOpgapEatListener;
import de.scholle.minecraftheroes.NoTotemListener;
import de.scholle.minecraftheroes.PlayerJoinListener;
import de.scholle.minecraftheroes.PunchEnchantBlocker;
import de.scholle.minecraftheroes.VillagerTradeBlocker;
import de.scholle.minecraftheroes.commands.DuelCommand;
import de.scholle.minecraftheroes.dummy.DummyListener;
import de.scholle.minecraftheroes.dummy.ListDummysCommand;
import de.scholle.minecraftheroes.leafdecay.BlockBreakEventListener;
import de.scholle.minecraftheroes.links.DiscordCommand;
import de.scholle.minecraftheroes.links.TexturepackCommand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CombatPlugin
extends JavaPlugin {
    private static CombatPlugin instance;
    public static CombatPlugin plugin;
    private CombatManager combatManager;
    private CobwebManager cobwebManager;
    private EnderPearlManager enderPearlManager;
    private CombatDisplayManager displayManager;
    private LivesStorage livesStorage;
    private DuelCommand duelCommand;
    private LanguageManager languageManager;
    private final HashMap<UUID, Integer> lives = new HashMap();
    private final HashSet<UUID> awaitingRevive = new HashSet();
    private boolean villagerTradingEnabled;
    private boolean loseLifeOnLogoutDuringCombat;
    private boolean noNether;
    private boolean noTotems;
    private boolean fireworkPlacementAllowed;
    private boolean noNetherite;
    private String messagePrefix;

    public void onEnable() {
        instance = this;
        plugin = this;
        this.saveDefaultConfig();
        this.loadPrefix();
        FileConfiguration config = this.getConfig();
        this.villagerTradingEnabled = config.getBoolean("villagerTradingEnabled", true);
        this.loseLifeOnLogoutDuringCombat = config.getBoolean("loseLifeOnLogoutDuringCombat", true);
        this.noNether = config.getBoolean("noNether", true);
        this.noTotems = config.getBoolean("NoTotems", true);
        this.fireworkPlacementAllowed = config.getBoolean("fireworkPlacementAllowed", false);
        this.noNetherite = config.getBoolean("noNetherite", true);
        this.livesStorage = new LivesStorage(this);
        this.lives.putAll(this.livesStorage.loadLives());
        this.combatManager = new CombatManager(this);
        this.cobwebManager = new CobwebManager(this);
        this.enderPearlManager = new EnderPearlManager(this);
        this.displayManager = new CombatDisplayManager(this, this.combatManager);
        this.duelCommand = new DuelCommand(this, this.combatManager);
        this.languageManager = new LanguageManager(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.combatManager, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CobwebListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new FireworkCrossbowBlocker(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PunchEnchantBlocker(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new VillagerTradeBlocker(this, this.villagerTradingEnabled), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CombatLogoutListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DummyListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new NoOpgapEatListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new NetherEnterBlocker(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockBreakEventListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new FireworkUseBlocker(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new NoTotemListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new NoNetheriteListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new EnderPearlListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getCommand("lives").setExecutor((CommandExecutor)new LivesCommand(this));
        this.getCommand("lives").setTabCompleter((TabCompleter)new CombatTabCompleter());
        this.getCommand("heart").setTabCompleter((TabCompleter)new CombatTabCompleter());
        this.getCommand("listdummys").setExecutor((CommandExecutor)new ListDummysCommand());
        this.getCommand("discord").setExecutor((CommandExecutor)new DiscordCommand(this));
        this.getCommand("dc").setExecutor((CommandExecutor)new DiscordCommand(this));
        this.getCommand("texturepack").setExecutor((CommandExecutor)new TexturepackCommand(this));
        this.getCommand("resourcepack").setExecutor((CommandExecutor)new TexturepackCommand(this));
        this.getCommand("duel").setExecutor((CommandExecutor)this.duelCommand);
        this.getLogger().info("CombatPlugin enabled.");
    }

    public void onDisable() {
        this.lives.forEach((uuid, value) -> this.livesStorage.setLives((UUID)uuid, (int)value));
        this.getLogger().info("CombatPlugin disabled.");
    }

    public static CombatPlugin getInstance() {
        return instance;
    }

    public CombatManager getCombatManager() {
        return this.combatManager;
    }

    public CobwebManager getCobwebManager() {
        return this.cobwebManager;
    }

    public EnderPearlManager getEnderPearlManager() {
        return this.enderPearlManager;
    }

    public LanguageManager getLanguage() {
        return this.languageManager;
    }

    public int getLives(UUID uuid) {
        return this.lives.getOrDefault(uuid, 3);
    }

    public void setLives(UUID uuid, int count) {
        this.lives.put(uuid, count);
        this.livesStorage.setLives(uuid, count);
    }

    public void removePlayer(UUID uuid) {
        this.lives.remove(uuid);
        this.livesStorage.remove(uuid);
        this.awaitingRevive.remove(uuid);
    }

    public boolean hasSavedLives(UUID uuid) {
        return this.livesStorage.loadLives().containsKey(uuid);
    }

    public Long getCombatEnd(UUID uuid) {
        Long timestamp = this.combatManager.getCombatTimestamps().get(uuid);
        if (timestamp == null) {
            return null;
        }
        return timestamp + 30000L;
    }

    public boolean isLoseLifeOnLogoutDuringCombatEnabled() {
        return this.loseLifeOnLogoutDuringCombat;
    }

    public double getKeepInventoryPercentageCombat() {
        return this.getConfig().getDouble("keepInventoryPercentageCombat", 0.5);
    }

    public double getKeepInventoryPercentageNatural() {
        return this.getConfig().getDouble("keepInventoryPercentageNatural", 0.0);
    }

    public void loadPrefix() {
        FileConfiguration config = this.getConfig();
        Object rawPrefix = config.getString("message-prefix", "\u00a76[Helden]");
        if (!((String)rawPrefix).endsWith(" ")) {
            rawPrefix = (String)rawPrefix + " ";
        }
        this.messagePrefix = rawPrefix;
    }

    public void sendMessage(Player player, String message) {
        if (player != null) {
            player.sendMessage(this.messagePrefix + message);
        }
    }

    public boolean isNoNether() {
        return this.noNether;
    }

    public boolean isNoTotems() {
        return this.noTotems;
    }

    public boolean isFireworkPlacementAllowed() {
        return this.fireworkPlacementAllowed;
    }

    public boolean isNoNetherite() {
        return this.noNetherite;
    }

    public DuelCommand getDuelCommand() {
        return this.duelCommand;
    }
}

