/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatPlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LivesCommand
implements CommandExecutor {
    private final CombatPlugin plugin;

    public LivesCommand(CombatPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguage().getMessage("lives.only_players"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("heroes.lives")) {
            this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.no_permission"));
            return true;
        }
        if (args.length == 0) {
            this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.usage"));
            return false;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("check")) {
            if (args.length < 2) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.check.usage"));
                return false;
            }
            String targetPlayerName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.player_not_online").replace("%player%", targetPlayerName));
                return true;
            }
            int lives = this.plugin.getLives(target.getUniqueId());
            this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.check.result").replace("%player%", targetPlayerName).replace("%lives%", String.valueOf(lives)));
        } else if (subCommand.equals("add")) {
            int amount;
            if (args.length < 3) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.add.usage"));
                return false;
            }
            String targetPlayerName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.player_not_online").replace("%player%", targetPlayerName));
                return true;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.amount_not_number"));
                return true;
            }
            int newLives = this.plugin.getLives(target.getUniqueId()) + amount;
            this.plugin.setLives(target.getUniqueId(), newLives);
            this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.add.result").replace("%player%", targetPlayerName).replace("%amount%", String.valueOf(amount)).replace("%lives%", String.valueOf(newLives)));
        } else if (subCommand.equals("set")) {
            int amount;
            if (args.length < 3) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.set.usage"));
                return false;
            }
            String targetPlayerName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetPlayerName);
            if (target == null) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.player_not_online").replace("%player%", targetPlayerName));
                return true;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.amount_not_number"));
                return true;
            }
            this.plugin.setLives(target.getUniqueId(), amount);
            this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.set.result").replace("%player%", targetPlayerName).replace("%lives%", String.valueOf(amount)));
        } else {
            this.plugin.sendMessage(player, this.plugin.getLanguage().getMessage("lives.invalid_subcommand"));
        }
        return true;
    }
}

