/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes;

import de.scholle.minecraftheroes.CombatPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LivesStorage {
    private final CombatPlugin plugin;
    private File file;
    private FileConfiguration config;

    public LivesStorage(CombatPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "lives.yml");
        if (!this.file.exists()) {
            plugin.saveResource("lives.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void setLives(UUID uuid, int lives) {
        this.config.set(uuid.toString(), (Object)lives);
        this.save();
    }

    public int getLives(UUID uuid) {
        return this.config.getInt(uuid.toString(), 3);
    }

    public void remove(UUID uuid) {
        this.config.set(uuid.toString(), null);
        this.save();
    }

    public HashMap<UUID, Integer> loadLives() {
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>();
        for (String key : this.config.getKeys(false)) {
            UUID uuid = UUID.fromString(key);
            int lives = this.config.getInt(key);
            map.put(uuid, lives);
        }
        return map;
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

