/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes.commands;

import de.scholle.minecraftheroes.CombatManager;
import de.scholle.minecraftheroes.CombatPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DuelCommand
implements CommandExecutor {
    private final CombatPlugin plugin;
    private final CombatManager combatManager;
    private final Map<UUID, UUID> duelRequests = new HashMap<UUID, UUID>();

    public DuelCommand(CombatPlugin plugin, CombatManager combatManager) {
        this.plugin = plugin;
        this.combatManager = combatManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguage().getMessage("duel.only_players"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("accept")) {
            UUID requesterUuid = this.duelRequests.remove(player.getUniqueId());
            if (requesterUuid == null) {
                player.sendMessage(this.plugin.getLanguage().getMessage("duel.no_request"));
                return true;
            }
            Player requester = Bukkit.getPlayer((UUID)requesterUuid);
            if (requester == null || !requester.isOnline()) {
                player.sendMessage(this.plugin.getLanguage().getMessage("duel.player_offline"));
                return true;
            }
            this.combatManager.startDuel(requester, player);
            return true;
        }
        if (args.length == 1) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendMessage(this.plugin.getLanguage().getMessage("duel.target_not_found"));
                return true;
            }
            if (player.equals((Object)target)) {
                player.sendMessage(this.plugin.getLanguage().getMessage("duel.self_duel"));
                return true;
            }
            this.duelRequests.put(target.getUniqueId(), player.getUniqueId());
            player.sendMessage(this.plugin.getLanguage().getMessage("duel.request_sent").replace("{target}", target.getName()));
            target.sendMessage(this.plugin.getLanguage().getMessage("duel.request_receive").replace("{player}", player.getName()));
            return true;
        }
        player.sendMessage(this.plugin.getLanguage().getMessage("duel.usage"));
        return true;
    }
}

