/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecraftheroes.leafdecay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;

public class BlockBreakEventListener
implements Listener {
    private final List<BlockFace> neighbours = new ArrayList<BlockFace>(List.of(BlockFace.values()));
    private final Set<Block> visited = new HashSet<Block>();

    public BlockBreakEventListener() {
        this.neighbours.remove(BlockFace.SELF);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        this.visited.clear();
        if (Tag.LOGS.isTagged((Keyed)block.getType())) {
            for (BlockFace face : this.neighbours) {
                Block neighbour = block.getRelative(face);
                if (!Tag.LEAVES.isTagged((Keyed)neighbour.getType()) || this.isLeafConnectedToLog(neighbour)) continue;
                this.breakLeaf(neighbour, true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLeavesDecay(LeavesDecayEvent event) {
        this.visited.clear();
        Block leaf = event.getBlock();
        if (!this.isLeafConnectedToLog(leaf)) {
            event.setCancelled(true);
            this.breakLeaf(leaf, true);
        }
    }

    private void breakLeaf(Block block, boolean breakFirstBlock) {
        if (!this.visited.add(block)) {
            return;
        }
        if (breakFirstBlock) {
            block.breakNaturally();
        }
        for (BlockFace face : this.neighbours) {
            Block neighbour = block.getRelative(face);
            if (!this.isValidLeaf(neighbour) || this.isLeafConnectedToLog(neighbour)) continue;
            this.breakLeaf(neighbour, true);
        }
    }

    private boolean isValidLeaf(Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Leaves)) {
            return false;
        }
        Leaves leafBlock = (Leaves)blockData;
        return !leafBlock.isPersistent();
    }

    private boolean isLeafConnectedToLog(Block leaf) {
        HashSet<Block> checked = new HashSet<Block>();
        LinkedList<Block> toCheck = new LinkedList<Block>();
        toCheck.add(leaf);
        while (!toCheck.isEmpty()) {
            Block current = (Block)toCheck.poll();
            if (!checked.add(current)) continue;
            if (Tag.LOGS.isTagged((Keyed)current.getType())) {
                return true;
            }
            if (!(current.getBlockData() instanceof Leaves)) continue;
            for (BlockFace face : this.neighbours) {
                toCheck.add(current.getRelative(face));
            }
        }
        return false;
    }
}

