/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.util.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HickoryLeavesBlock
extends LeavesBlock {
    public HickoryLeavesBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (pLevel.getBlockState(pPos.below()).isFaceSturdy((BlockGetter)pLevel, pPos.below(), Direction.UP)) {
            return;
        }
        SimpleParticleType particle = ModParticles.HICKORY_LEAF_PARTICLE.get();
        if ((double)pRandom.nextFloat() < 0.025) {
            ParticleUtils.spawnHickoryParticles(pLevel, pPos, pRandom, particle);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((double)pRandom.nextFloat() < 0.02) {
            this.spawnNewFallenLeaves((Level)pLevel, pPos, pRandom);
        }
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    private void spawnNewFallenLeaves(Level level, BlockPos pPos, RandomSource random) {
        if (level.isClientSide) {
            return;
        }
        int x = pPos.getX() + random.nextIntBetweenInclusive(-2, 2);
        int z = pPos.getZ() + random.nextIntBetweenInclusive(-2, 2);
        int groundY = -100;
        for (int y = pPos.getY(); y >= -64; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) continue;
            BlockState aboveState = level.getBlockState(pos.above());
            if (!aboveState.isAir() && !(aboveState.getBlock() instanceof FallenHickoryLeavesBlock)) break;
            groundY = y;
            break;
        }
        if (groundY > -64) {
            Direction direction;
            BlockPos target = new BlockPos(x, groundY + 1, z);
            BlockState state = level.getBlockState(target);
            int count = 1;
            if (state.getBlock() instanceof FallenHickoryLeavesBlock) {
                if (state.getValue(FallenHickoryLeavesBlock.COLOUR) != HickoryColour.HICKORY) {
                    return;
                }
                count = Math.min((Integer)level.getBlockState(target).getValue((Property)FallenHickoryLeavesBlock.COUNT) + 1, 3);
                direction = (Direction)level.getBlockState(target).getValue((Property)FallenHickoryLeavesBlock.FACING);
            } else {
                direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            }
            BlockState leafSt = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).defaultBlockState().setValue((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count))).setValue(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)HickoryColour.HICKORY))).setValue((Property)FallenHickoryLeavesBlock.FACING, (Comparable)direction);
            level.setBlock(target, leafSt, 3);
        }
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }
}

