/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import java.util.List;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.entity.custom.hickory.HickoryTreantEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RootBushBlock
extends SweetBerryBushBlock {
    private static final VoxelShape SAPLING_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public RootBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof LivingEntity && pEntity.getType() != EntityType.FOX && pEntity.getType() != EntityType.BEE && !(pEntity instanceof HickoryTreantEntity)) {
            pEntity.makeStuckInBlock(pState, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(pLevel.isClientSide || (Integer)pState.getValue((Property)AGE) <= 0 || pEntity.xOld == pEntity.getX() && pEntity.zOld == pEntity.getZ())) {
                double d0 = Math.abs(pEntity.getX() - pEntity.xOld);
                double d1 = Math.abs(pEntity.getZ() - pEntity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    pEntity.hurt(pLevel.damageSources().sweetBerryBush(), 1.0f);
                }
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)ModBlocks.HICKORY_ROOT_BUSH.get());
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        return InteractionResult.PASS;
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        return List.of();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SAPLING_SHAPE;
    }
}

