/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom.vibrion;

import java.util.List;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Sporeholder
extends SaplingBlock {
    public Sporeholder(TreeGrower p_311256_, BlockBehaviour.Properties p_55979_) {
        super(p_311256_, p_55979_);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return Sporeholder.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0).move(offset.x, 0.0, offset.z);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        pLevel.addParticle((ParticleOptions)ModParticles.VIBRION_PARTICLE.get(), (double)pPos.getX() + 0.5, (double)pPos.getY(), (double)pPos.getZ() + 0.5, 0.0, 0.0, 0.0);
        if (!pLevel.isClientSide()) {
            ContaminationHandler.addDose(pEntity, 40);
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        if (!pLevel.isClientSide()) {
            this.applySporeCloud((ServerLevel)pLevel, pPos);
        }
    }

    private void applySporeCloud(ServerLevel level, BlockPos center) {
        int radius = 2;
        RandomSource rand = level.getRandom();
        SimpleParticleType particle = ModParticles.VIBRION_PARTICLE.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dy * dy + dz * dz > radius * radius) continue;
                    for (int i = 0; i < 3; ++i) {
                        double x = (double)center.getX() + 0.5 + (double)dx + (rand.nextDouble() - 0.5);
                        double y = (double)center.getY() + 0.5 + (double)dy + (rand.nextDouble() - 0.5);
                        double z = (double)center.getZ() + 0.5 + (double)dz + (rand.nextDouble() - 0.5);
                        level.sendParticles((ParticleOptions)particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        AABB box = new AABB(center).inflate((double)radius);
        List list = level.getEntitiesOfClass(LivingEntity.class, box, e -> !e.isSpectator());
        for (LivingEntity entity : list) {
            ContaminationHandler.addDose((Entity)entity, 1000 + rand.nextInt(0, 1000));
            level.sendParticles((ParticleOptions)particle, entity.getX(), entity.getY() + 0.5, entity.getZ(), 5, 0.2, 0.2, 0.2, 0.01);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((double)random.nextFloat() < 0.5) {
            return;
        }
        level.addParticle((ParticleOptions)ModParticles.VIBRION_PARTICLE.get(), (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat() / 5.0f), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
    }
}

