/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import net.farkas.wildaside.block.custom.vibrion.PotionBlaster;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.screen.potion_blaster.PotionBlasterMenu;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.BlasterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PotionBlasterBlockEntity
extends BlasterBlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            PotionBlasterBlockEntity.this.setChanged();
            if (!((PotionBlasterBlockEntity)PotionBlasterBlockEntity.this).level.isClientSide) {
                PotionBlasterBlockEntity.this.level.sendBlockUpdated(PotionBlasterBlockEntity.this.getBlockPos(), PotionBlasterBlockEntity.this.getBlockState(), PotionBlasterBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    public static final int OUTPUT_1 = 9;
    public final ContainerData data;
    public int potionColour = 0;
    public int potionTicksLeft = 0;
    public int maxPotionTicks = 200;
    public int lastUsedSlot = -1;
    public ItemStack activePotion = ItemStack.EMPTY;
    public boolean shouldSelectNewPotion = true;

    public PotionBlasterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.POTION_BLASTER.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> PotionBlasterBlockEntity.this.potionTicksLeft;
                    case 1 -> PotionBlasterBlockEntity.this.maxPotionTicks;
                    case 2 -> PotionBlasterBlockEntity.this.potionColour;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        PotionBlasterBlockEntity.this.potionTicksLeft = pValue;
                        break;
                    }
                    case 1: {
                        PotionBlasterBlockEntity.this.maxPotionTicks = pValue;
                        break;
                    }
                    case 2: {
                        PotionBlasterBlockEntity.this.potionColour = pValue;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.wildaside.potion_blaster");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PotionBlasterMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void shootPotionBeam(Direction direction, ServerLevel level, BlockPos pos) {
        if (this.activePotion.isEmpty()) {
            return;
        }
        Iterable effects = ((PotionContents)this.activePotion.get(DataComponents.POTION_CONTENTS)).getAllEffects();
        this.potionColour = PotionContents.getColor((Iterable)effects);
        int power = level.getBestNeighborSignal(pos);
        this.setChanged();
        level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        float r = (float)(this.potionColour >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.potionColour >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.potionColour & 0xFF) / 255.0f;
        DustParticleOptions particle = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
        RandomSource random = level.random;
        for (int i = 1; i <= power; ++i) {
            BlockState originBlock;
            if (this.shouldBreakNext) {
                this.shouldBreakNext = false;
                break;
            }
            BlockPos target = pos.relative(direction, i);
            if (level.getBlockState(target).isCollisionShapeFullBlock((BlockGetter)level, target)) break;
            BlockState nextBlock = level.getBlockState(target);
            if (!BlasterUtils.canTraverse(direction, nextBlock, originBlock = level.getBlockState(this.getBlockPos()), this)) {
                return;
            }
            for (int k = 0; k < 2; ++k) {
                double x = (double)target.getX() + random.nextDouble();
                double y = (double)target.getY() + random.nextDouble();
                double z = (double)target.getZ() + random.nextDouble();
                level.sendParticles((ParticleOptions)particle, x, y, z, 1, (double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), 0.1);
            }
            List targets = level.getEntitiesOfClass(LivingEntity.class, new AABB(target));
            for (LivingEntity entity : targets) {
                for (MobEffectInstance effect : effects) {
                    entity.addEffect(new MobEffectInstance(effect.getEffect(), effect.getDuration() - (this.maxPotionTicks - this.potionTicksLeft), effect.getAmplifier()));
                    level.sendParticles((ParticleOptions)particle, entity.getX(), entity.getY(), entity.getZ(), 1, (double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), 0.1);
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer player = (ServerPlayer)entity;
                    AdvancementHandler.givePlayerAdvancement((Entity)player, "brew_barrage");
                }
            }
        }
    }

    public void consumePotionBottle() {
        this.activePotion = ItemStack.EMPTY;
        this.potionTicksLeft = 0;
        this.maxPotionTicks = 200;
        this.lastUsedSlot = -1;
        this.shouldSelectNewPotion = true;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void selectNewPotion() {
        Level level;
        if (!this.activePotion.isEmpty() || this.potionTicksLeft > 0) {
            return;
        }
        ArrayList<Integer> validSlots = new ArrayList<Integer>();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof PotionItem)) continue;
            validSlots.add(i);
        }
        if (validSlots.isEmpty()) {
            this.activePotion = ItemStack.EMPTY;
            this.lastUsedSlot = -1;
            this.shouldSelectNewPotion = true;
            return;
        }
        int slot = (Integer)validSlots.get(this.level.random.nextInt(validSlots.size()));
        ItemStack extracted = this.itemHandler.extractItem(slot, 1, false);
        if (extracted.isEmpty()) {
            this.shouldSelectNewPotion = true;
            this.lastUsedSlot = -1;
            this.activePotion = ItemStack.EMPTY;
            return;
        }
        ItemStack remainder = this.itemHandler.insertItem(9, new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
        if (!remainder.isEmpty() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, remainder));
        }
        this.activePotion = extracted.copy();
        this.lastUsedSlot = slot;
        this.shouldSelectNewPotion = false;
        Iterable effectInstances = ((PotionContents)this.activePotion.get(DataComponents.POTION_CONTENTS)).getAllEffects();
        List effects = StreamSupport.stream(effectInstances.spliterator(), false).toList();
        this.potionTicksLeft = this.maxPotionTicks = effects.isEmpty() ? 200 : effects.stream().mapToInt(MobEffectInstance::getDuration).max().orElse(200);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        pTag.putInt("ticks_left", this.potionTicksLeft);
        pTag.putInt("max_ticks", this.maxPotionTicks);
        pTag.putInt("colour", this.potionColour);
        if (this.activePotion.isEmpty()) {
            pTag.remove("potion");
        } else {
            pTag.put("potion", this.activePotion.save(pRegistries));
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
        this.potionTicksLeft = pTag.getInt("ticks_left");
        this.maxPotionTicks = pTag.getInt("max_ticks");
        this.potionColour = pTag.getInt("colour");
        this.activePotion = pTag.contains("potion") ? ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)pTag.getCompound("potion")) : ItemStack.EMPTY;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PotionBlasterBlockEntity) {
            PotionBlasterBlockEntity be = (PotionBlasterBlockEntity)blockEntity;
            if (level.getBestNeighborSignal(pos) > 0) {
                int poweredSides = 0;
                for (Direction dir : Direction.values()) {
                    if (level.getSignal(pos.relative(dir), dir) <= 0) continue;
                    ++poweredSides;
                }
                if (poweredSides >= 2) {
                    this.clearActivePotion();
                    return;
                }
                if ((this.potionTicksLeft <= 0 || this.activePotion.isEmpty()) && this.shouldSelectNewPotion) {
                    this.selectNewPotion();
                }
                if (!this.activePotion.isEmpty()) {
                    this.shootPotionBeam((Direction)state.getValue((Property)PotionBlaster.FACING), (ServerLevel)level, pos);
                    --this.potionTicksLeft;
                    if (this.potionTicksLeft <= 0) {
                        this.consumePotionBottle();
                    }
                }
            }
        }
    }

    public void clearActivePotion() {
        if (!this.activePotion.isEmpty()) {
            this.activePotion = ItemStack.EMPTY;
            this.potionTicksLeft = 0;
            this.lastUsedSlot = -1;
            this.shouldSelectNewPotion = true;
            this.setChanged();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }
}

