/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.client.vibrion;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.farkas.wildaside.entity.animations.MucellithAnimations;
import net.farkas.wildaside.entity.custom.vibrion.MucellithEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class MucellithModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart mucellith;
    private final ModelPart base;
    private final ModelPart body;
    private final ModelPart bottom;
    private final ModelPart bottomLeaves;
    private final ModelPart lowerMid;
    private final ModelPart lowerMidLeaves;
    private final ModelPart higherMid;
    private final ModelPart higherMidLeaves;
    private final ModelPart top;
    private final ModelPart topLeaves;
    private final ModelPart biggerHead;
    private final ModelPart headLeaves;
    private final ModelPart head;
    private final ModelPart mouth_base;
    private final ModelPart mouth_bottom;
    private final ModelPart mouth_top;

    public MucellithModel(ModelPart root) {
        this.mucellith = root.getChild("mucellith");
        this.base = this.mucellith.getChild("base");
        this.body = this.mucellith.getChild("body");
        this.bottom = this.body.getChild("bottom");
        this.bottomLeaves = this.bottom.getChild("bottomLeaves");
        this.lowerMid = this.bottom.getChild("lowerMid");
        this.lowerMidLeaves = this.lowerMid.getChild("lowerMidLeaves");
        this.higherMid = this.lowerMid.getChild("higherMid");
        this.higherMidLeaves = this.higherMid.getChild("higherMidLeaves");
        this.top = this.higherMid.getChild("top");
        this.topLeaves = this.top.getChild("topLeaves");
        this.biggerHead = this.top.getChild("biggerHead");
        this.headLeaves = this.biggerHead.getChild("headLeaves");
        this.head = this.biggerHead.getChild("head");
        this.mouth_base = this.head.getChild("mouth_base");
        this.mouth_bottom = this.head.getChild("mouth_bottom");
        this.mouth_top = this.head.getChild("mouth_top");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition mucellith = partdefinition.addOrReplaceChild("mucellith", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition base = mucellith.addOrReplaceChild("base", CubeListBuilder.create().texOffs(36, 24).addBox(-3.0f, -7.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = mucellith.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition bottom = body.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 58).addBox(-2.0f, -12.5171f, -2.0111f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition bottomLeaves = bottom.addOrReplaceChild("bottomLeaves", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-0.5171f, (float)-0.2611f));
        PartDefinition bottomLeaves_r1 = bottomLeaves.addOrReplaceChild("bottomLeaves_r1", CubeListBuilder.create().texOffs(36, 16).addBox(-8.0f, 0.0f, -8.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition bottomLeaves_r2 = bottomLeaves.addOrReplaceChild("bottomLeaves_r2", CubeListBuilder.create().texOffs(36, 8).addBox(0.0f, 0.0f, 0.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition bottomLeaves_r3 = bottomLeaves.addOrReplaceChild("bottomLeaves_r3", CubeListBuilder.create().texOffs(36, 0).addBox(0.0f, 0.0f, -8.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition bottomLeaves_r4 = bottomLeaves.addOrReplaceChild("bottomLeaves_r4", CubeListBuilder.create().texOffs(0, 36).addBox(-8.0f, 0.0f, 0.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition lowerMid = bottom.addOrReplaceChild("lowerMid", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0171f, (float)-0.2611f));
        PartDefinition lowerMidLeaves = lowerMid.addOrReplaceChild("lowerMidLeaves", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.4957f, (float)0.0653f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition lowerMidLeaves_r1 = lowerMidLeaves.addOrReplaceChild("lowerMidLeaves_r1", CubeListBuilder.create().texOffs(0, 51).addBox(-7.0f, 0.0f, -7.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0434f, (float)0.0038f, (float)-0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition lowerMidLeaves_r2 = lowerMidLeaves.addOrReplaceChild("lowerMidLeaves_r2", CubeListBuilder.create().texOffs(28, 44).addBox(0.0f, 0.0f, 0.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0434f, (float)0.0038f, (float)0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition lowerMidLeaves_r3 = lowerMidLeaves.addOrReplaceChild("lowerMidLeaves_r3", CubeListBuilder.create().texOffs(0, 44).addBox(0.0f, 0.0f, -7.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0434f, (float)0.0038f, (float)-0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition lowerMidLeaves_r4 = lowerMidLeaves.addOrReplaceChild("lowerMidLeaves_r4", CubeListBuilder.create().texOffs(32, 37).addBox(-7.0f, 0.0f, 0.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0434f, (float)0.0038f, (float)0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition higherMid = lowerMid.addOrReplaceChild("higherMid", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition higherMidLeaves = higherMid.addOrReplaceChild("higherMidLeaves", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.6783f, (float)0.5936f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition higherMidLeaves_r1 = higherMidLeaves.addOrReplaceChild("higherMidLeaves_r1", CubeListBuilder.create().texOffs(16, 63).addBox(-6.0f, 0.0f, -6.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.171f, (float)0.0302f, (float)-0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition higherMidLeaves_r2 = higherMidLeaves.addOrReplaceChild("higherMidLeaves_r2", CubeListBuilder.create().texOffs(60, 36).addBox(0.0f, 0.0f, 0.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.171f, (float)0.0302f, (float)0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition higherMidLeaves_r3 = higherMidLeaves.addOrReplaceChild("higherMidLeaves_r3", CubeListBuilder.create().texOffs(60, 30).addBox(0.0f, 0.0f, -6.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.171f, (float)0.0302f, (float)-0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition higherMidLeaves_r4 = higherMidLeaves.addOrReplaceChild("higherMidLeaves_r4", CubeListBuilder.create().texOffs(60, 24).addBox(-6.0f, 0.0f, 0.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.171f, (float)0.0302f, (float)0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition top = higherMid.addOrReplaceChild("top", CubeListBuilder.create().texOffs(68, 10).addBox(-1.5f, -7.4896f, -1.1084f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.15f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition topLeaves = top.addOrReplaceChild("topLeaves", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-1.4411f, (float)2.3164f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition topLeaves_r1 = topLeaves.addOrReplaceChild("topLeaves_r1", CubeListBuilder.create().texOffs(68, 5).addBox(-5.0f, 0.0f, -5.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.4276f, (float)-1.6213f, (float)-0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition topLeaves_r2 = topLeaves.addOrReplaceChild("topLeaves_r2", CubeListBuilder.create().texOffs(60, 63).addBox(0.0f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.4276f, (float)-1.6213f, (float)0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition topLeaves_r3 = topLeaves.addOrReplaceChild("topLeaves_r3", CubeListBuilder.create().texOffs(68, 0).addBox(0.0f, 0.0f, -5.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.4276f, (float)-1.6213f, (float)-0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition topLeaves_r4 = topLeaves.addOrReplaceChild("topLeaves_r4", CubeListBuilder.create().texOffs(40, 63).addBox(-5.0f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.4276f, (float)-1.6213f, (float)0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition biggerHead = top.addOrReplaceChild("biggerHead", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-7.762f, (float)0.708f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition headLeaves = biggerHead.addOrReplaceChild("headLeaves", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.7517f, (float)0.0f));
        PartDefinition headLeaves_r1 = headLeaves.addOrReplaceChild("headLeaves_r1", CubeListBuilder.create().texOffs(0, 9).addBox(-9.0f, 0.0f, -9.0f, 9.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.2906f, (float)-0.183f, (float)-0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition headLeaves_r2 = headLeaves.addOrReplaceChild("headLeaves_r2", CubeListBuilder.create().texOffs(0, 27).addBox(0.0f, 0.0f, -0.25f, 9.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.2906f, (float)0.067f, (float)0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition headLeaves_r3 = headLeaves.addOrReplaceChild("headLeaves_r3", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -9.0f, 9.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.2906f, (float)-0.183f, (float)-0.1309f, (float)0.0f, (float)-0.1309f));
        PartDefinition headLeaves_r4 = headLeaves.addOrReplaceChild("headLeaves_r4", CubeListBuilder.create().texOffs(0, 18).addBox(-9.0f, 0.0f, 0.0f, 9.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.2906f, (float)-0.183f, (float)0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition head = biggerHead.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.1737f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition mouth_base = head.addOrReplaceChild("mouth_base", CubeListBuilder.create().texOffs(56, 44).addBox(-3.5f, -1.2056f, -2.042f, 7.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth_bottom = head.addOrReplaceChild("mouth_bottom", CubeListBuilder.create().texOffs(50, 51).addBox(-4.0f, -8.9577f, -2.3094f, 8.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth_top = head.addOrReplaceChild("mouth_top", CubeListBuilder.create().texOffs(28, 51).addBox(-4.0f, -8.9577f, 0.6906f, 8.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.mucellith.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public ModelPart root() {
        return this.mucellith;
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(pNetHeadYaw, pHeadPitch, pAgeInTicks);
        this.animate(((MucellithEntity)((Object)pEntity)).idleAnimation, MucellithAnimations.IDLE, pAgeInTicks, 1.0f);
        this.animate(((MucellithEntity)((Object)pEntity)).attackAnimation, MucellithAnimations.ATTACK, pAgeInTicks, 1.0f);
        this.animate(((MucellithEntity)((Object)pEntity)).defenseAnimation, MucellithAnimations.TO_DEFENSE, pAgeInTicks, 1.0f);
        this.animate(((MucellithEntity)((Object)pEntity)).defenseAnimationReverse, MucellithAnimations.REVERSE_DEFENSE, pAgeInTicks, 1.0f);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.clamp((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-25.0f, (float)45.0f) + 40.0f;
        this.biggerHead.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.biggerHead.xRot = pHeadPitch * ((float)Math.PI / 180);
    }
}

