/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.item.custom;

import java.util.List;
import net.farkas.wildaside.entity.custom.vibrion.FertiliserBombEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class FertiliserBomb
extends Item
implements ProjectileItem {
    public FertiliserBomb(Item.Properties pProperties) {
        super(pProperties);
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return 200;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(pHand));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        Player player;
        block5: {
            block4: {
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!level.isClientSide) break block5;
            }
            return;
        }
        int chargeTime = this.getUseDuration(stack, entity) - timeLeft;
        float charge = Mth.clamp((float)((float)chargeTime / 20.0f), (float)0.0f, (float)1.0f);
        level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        FertiliserBombEntity thrown = new FertiliserBombEntity(level, (LivingEntity)player, charge);
        thrown.setItem(stack);
        thrown.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.8f + charge * 0.8f, 1.0f);
        level.addFreshEntity((Entity)thrown);
        if (!player.getAbilities().instabuild) {
            player.getCooldowns().addCooldown((Item)this, 100);
            stack.shrink(1);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.wildaside.fertiliser_bomb.tooltip"));
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        return new FertiliserBombEntity(level, position.x(), position.y(), position.z());
    }
}

