/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.farkas.wildaside.recipe.BioengineeringWorkstationRecipeInput;
import net.farkas.wildaside.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record BioengineeringWorkstationRecipe(List<Ingredient> ingredients, ItemStack output) implements Recipe<BioengineeringWorkstationRecipeInput>
{
    public static final Codec<Ingredient> INGREDIENT_ALLOW_EMPTY = Codec.either((Codec)Ingredient.CODEC_NONEMPTY, (Codec)Codec.unit((Object)Ingredient.EMPTY)).xmap(e -> (Ingredient)e.map(i -> i, i -> i), ing -> ing.isEmpty() ? Either.right((Object)Ingredient.EMPTY) : Either.left((Object)ing));

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.addAll(this.ingredients);
        return list;
    }

    public boolean matches(BioengineeringWorkstationRecipeInput pInput, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < pInput.size(); ++i) {
            ItemStack s = pInput.getItem(i);
            if (s.isEmpty()) continue;
            stacks.add(s.copy());
        }
        for (Ingredient ing : this.ingredients) {
            if (ing == Ingredient.EMPTY) continue;
            boolean matched = false;
            Iterator it = stacks.iterator();
            while (it.hasNext()) {
                ItemStack candidate = (ItemStack)it.next();
                if (!ing.test(candidate)) continue;
                it.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(BioengineeringWorkstationRecipeInput pInput, HolderLookup.Provider pRegistries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.BIOENGINEERING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.BIOENGINEERING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BioengineeringWorkstationRecipe> {
        public static final MapCodec<BioengineeringWorkstationRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.list(INGREDIENT_ALLOW_EMPTY).fieldOf("ingredients").forGetter(BioengineeringWorkstationRecipe::ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(BioengineeringWorkstationRecipe::output)).apply((Applicative)inst, BioengineeringWorkstationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BioengineeringWorkstationRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            for (Ingredient ing : recipe.ingredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)ing);
            }
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output());
        }, buf -> {
            ArrayList<Ingredient> ings = new ArrayList<Ingredient>(5);
            for (int i = 0; i < 5; ++i) {
                ings.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf));
            }
            ItemStack out = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            return new BioengineeringWorkstationRecipe(ings, out);
        });

        public MapCodec<BioengineeringWorkstationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BioengineeringWorkstationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

