/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.util;

import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.util.RandomSource;

public enum LargeMushroomCapShape {
    FLAT(false, 1),
    DOME(true, -1);

    private final boolean canDecorate;
    private final int yOffset;
    public static final Codec<LargeMushroomCapShape> CODEC;

    private LargeMushroomCapShape(boolean canDecorate, int yOffset) {
        this.canDecorate = canDecorate;
        this.yOffset = yOffset;
    }

    public boolean canDecorate() {
        return this.canDecorate;
    }

    public int yOffset() {
        return this.yOffset;
    }

    public static LargeMushroomCapShape pickWeightedShape(RandomSource random, Map<LargeMushroomCapShape, Float> weights) {
        float total = 0.0f;
        for (float w : weights.values()) {
            total += w;
        }
        float r = random.nextFloat() * total;
        float cumulative = 0.0f;
        for (Map.Entry<LargeMushroomCapShape, Float> entry : weights.entrySet()) {
            if (!(r <= (cumulative += entry.getValue().floatValue()))) continue;
            return entry.getKey();
        }
        return DOME;
    }

    static {
        CODEC = Codec.STRING.xmap(LargeMushroomCapShape::valueOf, Enum::name);
    }
}

