/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import java.util.List;
import net.farkas.wildaside.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.neoforge.registries.DeferredBlock;

public class GlowingHickoryBushFeature
extends Feature<NoneFeatureConfiguration> {
    public GlowingHickoryBushFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos pos = pContext.origin();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (level.getBlockState(pos.offset(x, -1, z)).isSolid()) continue;
                return false;
            }
        }
        RandomSource random = pContext.random();
        List<DeferredBlock<Block>> leavesOptions = List.of(ModBlocks.RED_GLOWING_HICKORY_LEAVES, ModBlocks.BROWN_GLOWING_HICKORY_LEAVES, ModBlocks.YELLOW_GLOWING_HICKORY_LEAVES, ModBlocks.GREEN_GLOWING_HICKORY_LEAVES);
        BlockState leaves = ((Block)leavesOptions.get(random.nextInt(leavesOptions.size())).get()).defaultBlockState();
        level.setBlock(pos, ((Block)ModBlocks.HICKORY_LOG.get()).defaultBlockState(), 3);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos newPos;
                if (x != 0 && z != 0 && !(random.nextFloat() < 0.25f) || level.getBlockState(newPos = pos.offset(x, 0, z)).isSolid()) continue;
                level.setBlock(newPos, leaves, 3);
                level.scheduleTick(newPos, level.getBlockState(newPos).getBlock(), 0);
            }
        }
        BlockPos topPos = pos.above();
        if (!level.getBlockState(topPos).isSolid()) {
            level.setBlock(topPos, leaves, 3);
            level.scheduleTick(topPos, level.getBlockState(topPos).getBlock(), 0);
        }
        return true;
    }
}

