/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.farkas.wildaside.util.LargeMushroomCapShape;
import net.farkas.wildaside.worldgen.feature.configuration.LargeMushroomConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;
import org.joml.SimplexNoise;

public class LargeMushroomFeature
extends Feature<LargeMushroomConfiguration> {
    public LargeMushroomFeature(Codec<LargeMushroomConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<LargeMushroomConfiguration> ctx) {
        LargeMushroomConfiguration config;
        WorldGenLevel level = ctx.level();
        RandomSource random = ctx.random();
        BlockPos origin = ctx.origin();
        BlockPos ground = this.findGround((LevelAccessor)level, origin, config = (LargeMushroomConfiguration)ctx.config());
        if (ground == null) {
            return false;
        }
        int clearance = this.findCeilingDistance(level, ground.above());
        if (clearance < config.minHeight()) {
            return false;
        }
        int height = Mth.clamp((int)random.nextIntBetweenInclusive(config.minHeight(), config.maxHeight()), (int)config.minHeight(), (int)config.maxHeight());
        height = Math.min(height, clearance - 2);
        Vec3 leanDir = this.calculateLeanDirection(level, ground);
        leanDir = this.exaggerateLean(level, ground, leanDir);
        if (!this.hasEnoughSpace((LevelAccessor)level, ground.above(), height, leanDir)) {
            return false;
        }
        this.generateStem((LevelAccessor)level, ground.above(), height, leanDir, config, random);
        LargeMushroomCapShape shape = LargeMushroomCapShape.pickWeightedShape(random, config.capShapeWeights());
        this.generateCap((LevelAccessor)level, ground.above(height), leanDir, config, random, height, shape);
        return true;
    }

    private BlockPos findGround(LevelAccessor level, BlockPos start, LargeMushroomConfiguration config) {
        BlockPos.MutableBlockPos pos = start.mutable();
        for (int dy = 0; dy < 8; ++dy) {
            BlockPos below = pos.below(dy);
            BlockState stateBelow = level.getBlockState(below);
            for (BlockStateProvider valid : config.validBaseBlocks()) {
                if (!stateBelow.is(valid.getState(level.getRandom(), (BlockPos)pos).getBlock()) || !level.isEmptyBlock(below.above())) continue;
                return below.above();
            }
        }
        return null;
    }

    private int findCeilingDistance(WorldGenLevel level, BlockPos pos) {
        int dist = 0;
        BlockPos.MutableBlockPos cursor = pos.mutable();
        while (cursor.getY() < level.getMaxBuildHeight()) {
            cursor.move(0, 1, 0);
            if (!level.isEmptyBlock((BlockPos)cursor)) break;
            ++dist;
        }
        return dist;
    }

    private Vec3 calculateLeanDirection(WorldGenLevel level, BlockPos base) {
        int radius = 4;
        Vec3 lean = Vec3.ZERO;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos check = base.offset(dx, 0, dz);
                int open = this.findCeilingDistance(level, check);
                double weight = (double)open - 4.0;
                lean = lean.add((double)dx * weight, 0.0, (double)dz * weight);
            }
        }
        if (lean.lengthSqr() < 0.01) {
            return Vec3.ZERO;
        }
        return lean.normalize();
    }

    private Vec3 exaggerateLean(WorldGenLevel level, BlockPos base, Vec3 lean) {
        if (lean.lengthSqr() < 0.01) {
            return lean;
        }
        int radius = 4;
        ArrayList<Integer> samples = new ArrayList<Integer>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                samples.add(this.findCeilingDistance(level, base.offset(dx, 0, dz)));
            }
        }
        double avg = samples.stream().mapToInt(i -> i).average().orElse(0.0);
        double stddev = Math.sqrt(samples.stream().mapToDouble(v -> ((double)v.intValue() - avg) * ((double)v.intValue() - avg)).sum() / (double)samples.size());
        double factor = Mth.clamp((double)(0.7 + stddev * 0.25), (double)0.7, (double)2.2);
        return lean.normalize().scale(factor);
    }

    private boolean hasEnoughSpace(LevelAccessor level, BlockPos base, int height, Vec3 leanDir) {
        int blocked = 0;
        for (int i = 0; i <= height + 3; ++i) {
            Vec3 offset = leanDir.scale((double)((float)i / (float)height) * 1.4);
            BlockPos check = base.offset((int)offset.x, i, (int)offset.z);
            if (level.isEmptyBlock(check) || ++blocked <= 12) continue;
            return false;
        }
        return true;
    }

    private void generateStem(LevelAccessor level, BlockPos base, int height, Vec3 leanDir, LargeMushroomConfiguration cfg, RandomSource random) {
        BlockState stem = cfg.stemBlock().getState(random, base);
        BlockState wood = cfg.woodBlock().getState(random, base);
        level.setBlock(base.below(), stem, 2);
        BlockPos lastPos = base;
        for (int i = 0; i < height; ++i) {
            Vec3 offset = leanDir.scale((double)((float)i / (float)height) * 1.2);
            BlockPos pos = base.offset((int)offset.x, i, (int)offset.z);
            if (level.isEmptyBlock(pos)) {
                level.setBlock(pos, stem, 2);
            }
            if ((pos.getX() != lastPos.getX() || pos.getZ() != lastPos.getZ()) && i > 0) {
                if (level.getBlockState(lastPos).is(stem.getBlock())) {
                    level.setBlock(lastPos, wood, 2);
                }
                if (level.getBlockState(pos).is(stem.getBlock())) {
                    level.setBlock(pos, wood, 2);
                }
            }
            lastPos = pos;
        }
    }

    private void generateCap(LevelAccessor level, BlockPos top, Vec3 leanDir, LargeMushroomConfiguration cfg, RandomSource random, int stemHeight, LargeMushroomCapShape shape) {
        Vec3 capOffset = leanDir.scale(1.0);
        BlockPos center = top.offset((int)capOffset.x, shape.yOffset(), (int)capOffset.z);
        BlockState capBlock = cfg.capBlock().getState(random, center);
        int radius = this.computeCapRadius(level, center, stemHeight, 6);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos decoPos;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > (double)radius + 0.3) continue;
                int capHeight = this.computeCapShape(shape, dist, radius);
                BlockPos pos = center.offset(dx, capHeight, dz);
                if (level.isEmptyBlock(pos)) {
                    level.setBlock(pos, capBlock, 2);
                }
                double innerRadius = (float)radius * 0.8f;
                if (!this.canDecorate(shape) || !(dist < innerRadius) || !(random.nextFloat() < 0.35f) || cfg.decoratorBlocks().isEmpty() || !level.isEmptyBlock(decoPos = pos.below())) continue;
                BlockState deco = cfg.decoratorBlocks().get(random.nextInt(cfg.decoratorBlocks().size())).getState(random, decoPos);
                level.setBlock(decoPos, deco, 2);
            }
        }
    }

    private int measureHeadroom(LevelAccessor level, BlockPos basePos, int maxSearch) {
        for (int dy = 1; dy < maxSearch; ++dy) {
            BlockPos checkPos = basePos.above(dy);
            if (level.getBlockState(checkPos).isAir()) continue;
            return dy - 1;
        }
        return maxSearch;
    }

    private double measureLateralOpenness(LevelAccessor level, BlockPos basePos, int maxRadius) {
        int openDirs = 0;
        int totalDirs = 0;
        for (int dx = -maxRadius; dx <= maxRadius; dx += maxRadius / 2) {
            for (int dz = -maxRadius; dz <= maxRadius; dz += maxRadius / 2) {
                if (dx == 0 && dz == 0) continue;
                ++totalDirs;
                BlockPos check = basePos.offset(dx, 1, dz);
                if (!level.getBlockState(check).isAir()) continue;
                ++openDirs;
            }
        }
        return (double)openDirs / (double)totalDirs;
    }

    private int computeCapRadius(LevelAccessor level, BlockPos basePos, int trunkHeight, int maxRadius) {
        int headroom = this.measureHeadroom(level, basePos, 12);
        double openness = this.measureLateralOpenness(level, basePos, 6);
        double heightFactor = 1.0 - Math.exp((double)(-trunkHeight) / 5.0);
        double spaceFactor = Math.min(1.0, (double)headroom / (double)trunkHeight * 0.8 + openness * 0.2);
        double variation = (double)(SimplexNoise.noise((float)((float)((double)basePos.getX() * 0.2)), (float)((float)((double)basePos.getZ() * 0.2))) + 1.0f) * 0.1 + 0.9;
        int radius = (int)((double)maxRadius * heightFactor * spaceFactor * variation);
        return Mth.clamp((int)radius, (int)2, (int)maxRadius);
    }

    private int computeCapShape(LargeMushroomCapShape shape, double dist, int radius) {
        return switch (shape) {
            case LargeMushroomCapShape.FLAT -> 0;
            default -> (int)(Math.cos(dist / (double)radius * Math.PI / 2.0) * 2.0);
        };
    }

    private boolean canDecorate(LargeMushroomCapShape shape) {
        return shape.canDecorate();
    }
}

