/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.worldgen.feature.decorator.ModTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class FallenLeavesDecorator
extends TreeDecorator {
    private final float chance;
    private final HickoryColour colour;
    public static final Codec<FallenLeavesDecorator> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(d -> Float.valueOf(d.chance)), (App)Codec.STRING.xmap(HickoryColour::valueOf, Enum::name).fieldOf("colour").forGetter(d -> d.colour)).apply((Applicative)inst, FallenLeavesDecorator::new));

    public FallenLeavesDecorator(float chance, HickoryColour colour) {
        this.chance = chance;
        this.colour = colour;
    }

    protected TreeDecoratorType<?> type() {
        return ModTreeDecorators.FALLEN_LEAVES.get();
    }

    public void place(TreeDecorator.Context pContext) {
        RandomSource random = pContext.random();
        ObjectArrayList logs = pContext.logs();
        BlockPos anyLog = (BlockPos)logs.get(0);
        int cx = anyLog.getX();
        int cz = anyLog.getZ();
        LevelSimulatedReader reader = pContext.level();
        int radius = 6;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (!(random.nextFloat() < this.chance)) continue;
                int x = cx + dx;
                int z = cz + dz;
                int startY = logs.stream().mapToInt(Vec3i::getY).min().orElse(0) + 5;
                int groundY = -100;
                for (int y = startY; y >= -64; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!reader.isStateAtPosition(pos, bs -> bs.is(BlockTags.DIRT))) continue;
                    if (!reader.isStateAtPosition(pos.above(), bs -> !bs.isSolid())) break;
                    groundY = y;
                    break;
                }
                if (groundY <= -64) continue;
                BlockPos target = new BlockPos(x, groundY + 1, z);
                int count = 1 + random.nextInt(3);
                HickoryColour colour = this.colour;
                Direction face = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                BlockState leafSt = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).defaultBlockState().setValue((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count))).setValue(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)colour))).setValue((Property)FallenHickoryLeavesBlock.FACING, (Comparable)face);
                pContext.setBlock(target, leafSt);
            }
        }
    }
}

