/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block;

import java.util.EnumMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.farkas.wildaside.block.custom.BioengineeringWorkstation;
import net.farkas.wildaside.block.custom.EntoriumOre;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.block.custom.GlowingHickoryLeavesBlock;
import net.farkas.wildaside.block.custom.GlowingHickorySaplingBlock;
import net.farkas.wildaside.block.custom.HickoryLeavesBlock;
import net.farkas.wildaside.block.custom.ModFlammableBlock;
import net.farkas.wildaside.block.custom.ModFlammableRotatedPillarBlock;
import net.farkas.wildaside.block.custom.OvergrownEntoriumOre;
import net.farkas.wildaside.block.custom.RootBushBlock;
import net.farkas.wildaside.block.custom.SubstiliumRedstoneOre;
import net.farkas.wildaside.block.custom.SubstiliumSoil;
import net.farkas.wildaside.block.custom.sign.ModHangingSignBlock;
import net.farkas.wildaside.block.custom.sign.ModStandingSignBlock;
import net.farkas.wildaside.block.custom.sign.ModWallHangingSignBlock;
import net.farkas.wildaside.block.custom.sign.ModWallSignBlock;
import net.farkas.wildaside.block.custom.vibrion.BouncyExperienceBlock;
import net.farkas.wildaside.block.custom.vibrion.NaturalSporeBlaster;
import net.farkas.wildaside.block.custom.vibrion.PotionBlaster;
import net.farkas.wildaside.block.custom.vibrion.SporeAir;
import net.farkas.wildaside.block.custom.vibrion.SporeBlaster;
import net.farkas.wildaside.block.custom.vibrion.Sporeholder;
import net.farkas.wildaside.block.custom.vibrion.VibrionGel;
import net.farkas.wildaside.block.custom.vibrion.VibrionGlass;
import net.farkas.wildaside.block.custom.vibrion.hanging_vines.HangingVibrionVines;
import net.farkas.wildaside.block.custom.vibrion.hanging_vines.HangingVibrionVinesPlant;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.util.ModWoodTypes;
import net.farkas.wildaside.worldgen.feature.tree.ModTreeGrowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"wildaside");
    public static final DeferredBlock<Block> VIBRION_BLOCK = ModBlocks.registerBlock("vibrion_block", () -> new BouncyExperienceBlock((IntProvider)UniformInt.of((int)1, (int)2), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.SHROOMLIGHT).strength(2.0f, 1.0f).lightLevel(l -> 9)));
    public static final DeferredBlock<Block> COMPRESSED_VIBRION_BLOCK = ModBlocks.registerBlock("compressed_vibrion_block", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRION_BLOCK.get())).lightLevel(s -> 15)));
    public static final DeferredBlock<Block> VIBRION_GEL = ModBlocks.registerBlock("vibrion_gel", () -> new VibrionGel(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.HONEY_BLOCK).strength(0.1f, 0.0f).noCollission().noOcclusion().isRedstoneConductor((bs, br, bp) -> false).noOcclusion()));
    public static final DeferredBlock<Block> LIT_VIBRION_GEL = ModBlocks.registerBlock("lit_vibrion_gel", () -> new VibrionGel(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRION_GEL.get())).lightLevel(s -> 9)));
    public static final DeferredBlock<Block> VIBRION_GLASS = ModBlocks.registerBlock("vibrion_glass", () -> new VibrionGlass(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.GLASS).strength(0.4f, 0.3f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).instrument(NoteBlockInstrument.HAT)));
    public static final DeferredBlock<Block> LIT_VIBRION_GLASS = ModBlocks.registerBlock("lit_vibrion_glass", () -> new VibrionGlass(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRION_GLASS.get())).lightLevel(s -> 7)));
    public static final DeferredBlock<Block> VIBRION_GLASS_PANE = ModBlocks.registerBlock("vibrion_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRION_GLASS.get()))));
    public static final DeferredBlock<Block> LIT_VIBRION_GLASS_PANE = ModBlocks.registerBlock("lit_vibrion_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRION_GLASS_PANE.get())).lightLevel(s -> 7)));
    public static final DeferredBlock<Block> VIBRION_GROWTH = ModBlocks.registerBlock("vibrion_growth", () -> new FlowerBlock(MobEffects.POISON, 5.0f, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.ROOTS).lightLevel(s -> 3).noCollission().noOcclusion().replaceable().instabreak().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> POTTED_VIBRION_GROWTH = BLOCKS.register("potted_vibrion_growth", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, VIBRION_GROWTH, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_CRIMSON_ROOTS).mapColor(MapColor.COLOR_YELLOW).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> VIBRION_SPOREHOLDER = ModBlocks.registerBlock("vibrion_sporeholder", () -> new Sporeholder(ModTreeGrowers.SUBSTILIUM_MUSHROOM, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.FUNGUS).lightLevel(l -> 5).noCollission().noOcclusion().strength(1.5f, 2.0f).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> HANGING_VIBRION_VINES = ModBlocks.registerBlock("hanging_vibrion_vines", () -> new HangingVibrionVines(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.WEEPING_VINES).lightLevel(l -> 5).noCollission().noOcclusion().replaceable().isRedstoneConductor((bs, br, bp) -> false).strength(0.3f, 0.5f).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> HANGING_VIBRION_VINES_PLANT = ModBlocks.registerBlock("hanging_vibrion_vines_plant", () -> new HangingVibrionVinesPlant(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HANGING_VIBRION_VINES.get()))));
    public static final DeferredBlock<Block> SPORE_AIR = ModBlocks.registerBlock("spore_air", () -> new SporeAir(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AIR).mapColor(MapColor.COLOR_YELLOW).noLootTable()));
    public static final DeferredBlock<Block> ENTORIUM_SHROOM = ModBlocks.registerBlock("entorium_shroom", () -> new HugeMushroomBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).sound(SoundType.WART_BLOCK).strength(1.2f, 1.5f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> OVERGROWN_ENTORIUM_ORE = ModBlocks.registerBlock("overgrown_entorium_ore", () -> new OvergrownEntoriumOre(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).sound(SoundType.NETHER_ORE).strength(3.5f, 12.0f)));
    public static final DeferredBlock<Block> ENTORIUM_ORE = ModBlocks.registerBlock("entorium_ore", () -> new EntoriumOre(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).sound(SoundType.NETHER_ORE).strength(3.0f, 12.0f)));
    public static final DeferredBlock<Block> SUBSTILIUM_COAL_ORE = ModBlocks.registerBlock("substilium_coal_ore", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)0, (int)3), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COAL_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_COPPER_ORE = ModBlocks.registerBlock("substilium_copper_ore", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)0, (int)1), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_LAPIS_ORE = ModBlocks.registerBlock("substilium_lapis_ore", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)2, (int)6), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAPIS_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_IRON_ORE = ModBlocks.registerBlock("substilium_iron_ore", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)0, (int)1), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_GOLD_ORE = ModBlocks.registerBlock("substilium_gold_ore", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)0, (int)1), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_REDSTONE_ORE = ModBlocks.registerBlock("substilium_redstone_ore", () -> new SubstiliumRedstoneOre((IntProvider)UniformInt.of((int)0, (int)1), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_DIAMOND_ORE = ModBlocks.registerBlock("substilium_diamond_ore", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)3, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_EMERALD_ORE = ModBlocks.registerBlock("substilium_emerald_ore", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)3, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.EMERALD_ORE).sound(SoundType.ROOTED_DIRT)));
    public static final DeferredBlock<Block> SUBSTILIUM_SOIL = ModBlocks.registerBlock("substilium_soil", () -> new SubstiliumSoil((IntProvider)UniformInt.of((int)0, (int)0), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).sound(SoundType.ROOTED_DIRT).strength(1.0f, 2.0f)));
    public static final DeferredBlock<Block> COMPRESSED_SUBSTILIUM_SOIL = ModBlocks.registerBlock("compressed_substilium_soil", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).sound(SoundType.DEEPSLATE).requiresCorrectToolForDrops().strength(2.0f, 12.0f)){

        public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
            return TriState.TRUE;
        }
    });
    public static final DeferredBlock<Block> NATURAL_SPORE_BLASTER = ModBlocks.registerBlock("natural_spore_blaster", () -> new NaturalSporeBlaster(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_SOIL.get())).noOcclusion().strength(6.0f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPORE_BLASTER = ModBlocks.registerBlock("spore_blaster", () -> new SporeBlaster(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COMPRESSED_SUBSTILIUM_SOIL.get())).noOcclusion().strength(6.0f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POTION_BLASTER = ModBlocks.registerBlock("potion_blaster", () -> new PotionBlaster(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SPORE_BLASTER.get()))));
    public static final DeferredBlock<Block> SMOOTH_SUBSTILIUM_SOIL = ModBlocks.registerBlock("smooth_substilium_soil", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COMPRESSED_SUBSTILIUM_SOIL.get()))));
    public static final DeferredBlock<Block> CHISELED_SUBSTILIUM_SOIL = ModBlocks.registerBlock("chiseled_substilium_soil", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COMPRESSED_SUBSTILIUM_SOIL.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_TILES = ModBlocks.registerBlock("substilium_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COMPRESSED_SUBSTILIUM_SOIL.get()))));
    public static final DeferredBlock<Block> CRACKED_SUBSTILIUM_TILES = ModBlocks.registerBlock("cracked_substilium_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COMPRESSED_SUBSTILIUM_SOIL.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_TILE_STAIRS = ModBlocks.registerBlock("substilium_tile_stairs", () -> new StairBlock(((Block)SUBSTILIUM_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_TILES.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_TILE_SLAB = ModBlocks.registerBlock("substilium_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_TILES.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_TILE_BUTTON = ModBlocks.registerBlock("substilium_tile_button", () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).sound(SoundType.DEEPSLATE).strength(1.0f, 12.0f)));
    public static final DeferredBlock<Block> SUBSTILIUM_TILE_PRESSURE_PLATE = ModBlocks.registerBlock("substilium_tile_pressure_plate", () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_TILE_BUTTON.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_TILE_WALLS = ModBlocks.registerBlock("substilium_tile_walls", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_TILES.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_STEM = ModBlocks.registerBlock("substilium_stem", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.STEM).strength(2.0f, 2.0f)));
    public static final DeferredBlock<Block> STRIPPED_SUBSTILIUM_STEM = ModBlocks.registerBlock("stripped_substilium_stem", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_STEM.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_WOOD = ModBlocks.registerBlock("substilium_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_STEM.get()))));
    public static final DeferredBlock<Block> STRIPPED_SUBSTILIUM_WOOD = ModBlocks.registerBlock("stripped_substilium_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_WOOD.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_PLANKS = ModBlocks.registerBlock("substilium_planks", () -> new ModFlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_STEM.get())).sound(SoundType.WOOD), 10, 5));
    public static final DeferredBlock<Block> SUBSTILIUM_STAIRS = ModBlocks.registerBlock("substilium_stairs", () -> new StairBlock(((Block)SUBSTILIUM_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_SLAB = ModBlocks.registerBlock("substilium_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_BUTTON = ModBlocks.registerBlock("substilium_button", () -> new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get())).strength(1.0f, 1.0f)));
    public static final DeferredBlock<Block> SUBSTILIUM_PRESSURE_PLATE = ModBlocks.registerBlock("substilium_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_BUTTON.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_FENCE = ModBlocks.registerBlock("substilium_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_FENCE_GATE = ModBlocks.registerBlock("substilium_fence_gate", () -> new FenceGateBlock(Optional.of(ModWoodTypes.SUBSTILIUM), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get())), Optional.of(SoundEvents.FENCE_GATE_OPEN), Optional.of(SoundEvents.FENCE_GATE_CLOSE)));
    public static final DeferredBlock<Block> SUBSTILIUM_DOOR = ModBlocks.registerBlock("substilium_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get()))));
    public static final DeferredBlock<Block> SUBSTILIUM_TRAPDOOR = ModBlocks.registerBlock("substilium_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get())).noOcclusion()));
    public static final DeferredBlock<Block> SUBSTILIUM_SIGN = BLOCKS.register("substilium_sign", () -> new ModStandingSignBlock(ModWoodTypes.SUBSTILIUM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> SUBSTILIUM_WALL_SIGN = BLOCKS.register("substilium_wall_sign", () -> new ModWallSignBlock(ModWoodTypes.SUBSTILIUM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> SUBSTILIUM_HANGING_SIGN = BLOCKS.register("substilium_hanging_sign", () -> new ModHangingSignBlock(ModWoodTypes.SUBSTILIUM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> SUBSTILIUM_WALL_HANGING_SIGN = BLOCKS.register("substilium_hanging_wall_sign", () -> new ModWallHangingSignBlock(ModWoodTypes.SUBSTILIUM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SUBSTILIUM_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> SUBSTILIUM_SPROUTS = ModBlocks.registerBlock("substilium_sprouts", () -> new FlowerBlock(MobEffects.CONFUSION, 5.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRION_GROWTH.get())).mapColor(MapColor.COLOR_CYAN).lightLevel(l -> 0)));
    public static final DeferredBlock<Block> BIOENGINEERING_WORKSTATION = ModBlocks.registerBlock("bioengineering_workstation", () -> new BioengineeringWorkstation(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> HICKORY_LOG = ModBlocks.registerBlock("hickory_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(MapColor.TERRACOTTA_ORANGE).strength(2.5f, 4.0f)));
    public static final DeferredBlock<Block> HICKORY_WOOD = ModBlocks.registerBlock("hickory_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_LOG.get()))));
    public static final DeferredBlock<Block> STRIPPED_HICKORY_LOG = ModBlocks.registerBlock("stripped_hickory_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_LOG.get()))));
    public static final DeferredBlock<Block> STRIPPED_HICKORY_WOOD = ModBlocks.registerBlock("stripped_hickory_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_LOG.get()))));
    public static final DeferredBlock<Block> HICKORY_PLANKS = ModBlocks.registerBlock("hickory_planks", () -> new ModFlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_LOG.get())), 10, 5));
    public static final DeferredBlock<Block> HICKORY_STAIRS = ModBlocks.registerBlock("hickory_stairs", () -> new StairBlock(((Block)HICKORY_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get()))));
    public static final DeferredBlock<Block> HICKORY_SLAB = ModBlocks.registerBlock("hickory_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get()))));
    public static final DeferredBlock<Block> HICKORY_BUTTON = ModBlocks.registerBlock("hickory_button", () -> new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get())).strength(1.0f, 1.0f)));
    public static final DeferredBlock<Block> HICKORY_PRESSURE_PLATE = ModBlocks.registerBlock("hickory_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_BUTTON.get()))));
    public static final DeferredBlock<Block> HICKORY_FENCE = ModBlocks.registerBlock("hickory_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get()))));
    public static final DeferredBlock<Block> HICKORY_FENCE_GATE = ModBlocks.registerBlock("hickory_fence_gate", () -> new FenceGateBlock(Optional.of(ModWoodTypes.HICKORY), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get())), Optional.of(SoundEvents.FENCE_GATE_OPEN), Optional.of(SoundEvents.FENCE_GATE_CLOSE)));
    public static final DeferredBlock<Block> HICKORY_DOOR = ModBlocks.registerBlock("hickory_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get()))));
    public static final DeferredBlock<Block> HICKORY_TRAPDOOR = ModBlocks.registerBlock("hickory_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get())).noOcclusion()));
    public static final DeferredBlock<Block> HICKORY_SIGN = BLOCKS.register("hickory_sign", () -> new ModStandingSignBlock(ModWoodTypes.HICKORY, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> HICKORY_WALL_SIGN = BLOCKS.register("hickory_wall_sign", () -> new ModWallSignBlock(ModWoodTypes.HICKORY, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> HICKORY_HANGING_SIGN = BLOCKS.register("hickory_hanging_sign", () -> new ModHangingSignBlock(ModWoodTypes.HICKORY, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> HICKORY_WALL_HANGING_SIGN = BLOCKS.register("hickory_hanging_wall_sign", () -> new ModWallHangingSignBlock(ModWoodTypes.HICKORY, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)HICKORY_PLANKS.get())).strength(1.0f).forceSolidOn().noCollission()));
    public static final DeferredBlock<Block> SPOTTED_WINTERGREEN = ModBlocks.registerBlock("spotted_wintergreen", () -> new FlowerBlock(MobEffects.MOVEMENT_SPEED, 10.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_TULIP)));
    public static final DeferredBlock<Block> PINKSTER_FLOWER = ModBlocks.registerBlock("pinkster_flower", () -> new FlowerBlock(MobEffects.CONFUSION, 10.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_TULIP)));
    public static final DeferredBlock<Block> HICKORY_LEAVES = ModBlocks.registerBlock("hickory_leaves", () -> new HickoryLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final DeferredBlock<Block> RED_GLOWING_HICKORY_LEAVES = ModBlocks.registerBlock("red_glowing_hickory_leaves", () -> new GlowingHickoryLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), HickoryColour.RED_GLOWING));
    public static final DeferredBlock<Block> BROWN_GLOWING_HICKORY_LEAVES = ModBlocks.registerBlock("brown_glowing_hickory_leaves", () -> new GlowingHickoryLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), HickoryColour.BROWN_GLOWING));
    public static final DeferredBlock<Block> YELLOW_GLOWING_HICKORY_LEAVES = ModBlocks.registerBlock("yellow_glowing_hickory_leaves", () -> new GlowingHickoryLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), HickoryColour.YELLOW_GLOWING));
    public static final DeferredBlock<Block> GREEN_GLOWING_HICKORY_LEAVES = ModBlocks.registerBlock("green_glowing_hickory_leaves", () -> new GlowingHickoryLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), HickoryColour.GREEN_GLOWING));
    public static final EnumMap<HickoryColour, DeferredBlock<Block>> HICKORY_LEAVES_BLOCKS = new EnumMap(HickoryColour.class);
    public static final DeferredBlock<Block> FALLEN_HICKORY_LEAVES;
    public static final DeferredBlock<Block> HICKORY_SAPLING;
    public static final DeferredBlock<Block> RED_GLOWING_HICKORY_SAPLING;
    public static final DeferredBlock<Block> BROWN_GLOWING_HICKORY_SAPLING;
    public static final DeferredBlock<Block> YELLOW_GLOWING_HICKORY_SAPLING;
    public static final DeferredBlock<Block> GREEN_GLOWING_HICKORY_SAPLING;
    public static final EnumMap<HickoryColour, DeferredBlock<Block>> HICKORY_SAPLINGS;
    public static final DeferredBlock<Block> HICKORY_ROOT_BUSH;

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock blockObj = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, blockObj);
        return blockObj;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithStackLimit(String name, Supplier<T> block, int stackLimit) {
        DeferredBlock blockObj = BLOCKS.register(name, block);
        ModBlocks.registerBlockItemWithStackLimit(name, blockObj, stackLimit);
        return blockObj;
    }

    private static <T extends Block> void registerBlockItemWithStackLimit(String name, DeferredBlock<T> block, int stackLimit) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().stacksTo(stackLimit)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    static {
        HICKORY_LEAVES_BLOCKS.put(HickoryColour.HICKORY, HICKORY_LEAVES);
        HICKORY_LEAVES_BLOCKS.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_LEAVES);
        HICKORY_LEAVES_BLOCKS.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_LEAVES);
        HICKORY_LEAVES_BLOCKS.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_LEAVES);
        HICKORY_LEAVES_BLOCKS.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_LEAVES);
        FALLEN_HICKORY_LEAVES = ModBlocks.registerBlock("fallen_hickory_leaves", () -> new FallenHickoryLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).noCollission().noOcclusion().instabreak().replaceable().pushReaction(PushReaction.DESTROY)));
        HICKORY_SAPLING = ModBlocks.registerBlock("hickory_sapling", () -> new SaplingBlock(ModTreeGrowers.HICKORY_TREE_GROWER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
        RED_GLOWING_HICKORY_SAPLING = ModBlocks.registerBlock("red_glowing_hickory_sapling", () -> new GlowingHickorySaplingBlock(ModTreeGrowers.RED_GLOWING_HICKORY_TREE_GROWER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
        BROWN_GLOWING_HICKORY_SAPLING = ModBlocks.registerBlock("brown_glowing_hickory_sapling", () -> new GlowingHickorySaplingBlock(ModTreeGrowers.BROWN_GLOWING_HICKORY_TREE_GROWER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RED_GLOWING_HICKORY_SAPLING.get()))));
        YELLOW_GLOWING_HICKORY_SAPLING = ModBlocks.registerBlock("yellow_glowing_hickory_sapling", () -> new GlowingHickorySaplingBlock(ModTreeGrowers.YELLOW_GLOWING_HICKORY_TREE_GROWER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RED_GLOWING_HICKORY_SAPLING.get()))));
        GREEN_GLOWING_HICKORY_SAPLING = ModBlocks.registerBlock("green_glowing_hickory_sapling", () -> new GlowingHickorySaplingBlock(ModTreeGrowers.GREEN_GLOWING_HICKORY_TREE_GROWER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RED_GLOWING_HICKORY_SAPLING.get()))));
        HICKORY_SAPLINGS = new EnumMap(HickoryColour.class);
        HICKORY_SAPLINGS.put(HickoryColour.HICKORY, HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_SAPLING);
        HICKORY_ROOT_BUSH = ModBlocks.registerBlock("hickory_root_bush", () -> new RootBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).strength(0.5f)));
    }
}

