/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import java.util.Collections;
import java.util.List;
import net.farkas.wildaside.block.custom.GlowingHickoryLeavesBlock;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.item.custom.HickoryLeafItem;
import net.farkas.wildaside.util.GlowingHickoryLightUtil;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallenHickoryLeavesBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.5, (double)15.0);
    public static final int MAX_COUNT = 3;
    public static final EnumProperty<HickoryColour> COLOUR = EnumProperty.create((String)"colour", HickoryColour.class);
    public static final IntegerProperty COUNT = IntegerProperty.create((String)"count", (int)1, (int)3);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final int MIN_LIGHT = 0;
    private static final int MAX_LIGHT = 3;
    public static final IntegerProperty LIGHT = IntegerProperty.create((String)"light", (int)0, (int)3);
    public static final BooleanProperty FIXED_LIGHTING = BooleanProperty.create((String)"fixed_lighting");

    public FallenHickoryLeavesBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.lightLevel(s -> (Integer)s.getValue((Property)LIGHT)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLOUR, (Comparable)((Object)HickoryColour.HICKORY))).setValue((Property)COUNT, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(false)));
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        HickoryColour colour = (HickoryColour)((Object)pState.getValue(COLOUR));
        int count = (Integer)pState.getValue((Property)COUNT);
        return Collections.singletonList(new ItemStack((ItemLike)ModItems.LEAF_ITEMS.get((Object)colour).get(), count));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOUR, COUNT, FACING, LIGHT, FIXED_LIGHTING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        HickoryColour color = HickoryColour.HICKORY;
        Item item = stack.getItem();
        if (item instanceof HickoryLeafItem) {
            HickoryLeafItem leaf = (HickoryLeafItem)item;
            color = leaf.getColour();
        }
        Direction face = ctx.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(COLOUR, (Comparable)((Object)color))).setValue((Property)COUNT, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)face);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pLevel.isClientSide || pHand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack playerItem = pPlayer.getItemInHand(pHand);
        if (playerItem.isEmpty()) {
            int count = (Integer)pState.getValue((Property)COUNT);
            if (count == 1) {
                pLevel.removeBlock(pPos, false);
            } else {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)COUNT, (Comparable)Integer.valueOf(count - 1)), 3);
            }
            pPlayer.swing(pHand);
            pPlayer.addItem(new ItemStack((ItemLike)ModItems.LEAF_ITEMS.get(pState.getValue(COLOUR)).get()));
            pLevel.playSound(null, pPos, SoundEvents.BIG_DRIPLEAF_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!pPlayer.isInvulnerable()) {
                playerItem.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (playerItem.getItem().equals(ModItems.VIBRION.get())) {
            if (((Boolean)pState.getValue((Property)GlowingHickoryLeavesBlock.FIXED_LIGHTING)).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(true)), 3);
            pLevel.playSound(null, pPos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!pPlayer.isInvulnerable()) {
                playerItem.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, 0);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        if (pLevel.isClientSide() || ((Boolean)pState.getValue((Property)FIXED_LIGHTING)).booleanValue() || pState.getValue(COLOUR) == HickoryColour.HICKORY) {
            return;
        }
        int maxLight = (Integer)pState.getValue((Property)COUNT);
        int time = (int)pLevel.dayTime();
        int currentLight = (Integer)pState.getValue((Property)LIGHT);
        int newLight = GlowingHickoryLightUtil.getLight(time, 0, maxLight);
        if (newLight != currentLight) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)LIGHT, (Comparable)Integer.valueOf(newLight)));
        }
        pLevel.scheduleTick(pPos, (Block)this, 100);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModItems.LEAF_ITEMS.get(state.getValue(COLOUR)).get());
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).isFaceSturdy((BlockGetter)pLevel, pPos.below(), Direction.UP);
    }

    public BlockState updateShape(BlockState st, Direction side, BlockState nb, LevelAccessor w, BlockPos p, BlockPos np) {
        if (side == Direction.DOWN && !this.canSurvive(st, (LevelReader)w, p)) {
            w.destroyBlock(p, true);
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(st, side, nb, w, p, np);
    }
}

