/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.List;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.BlasterUtils;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class NaturalSporeBlasterBlockEntity
extends BlasterBlockEntity {
    private static final int MAX_TIMER = 40;
    private int changePowerTimer = 40;
    private int power1 = 0;
    private int power2 = 0;

    public NaturalSporeBlasterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.NATURAL_SPORE_BLASTER.get(), pos, state);
    }

    public void tickServer() {
        Direction.Axis axis;
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        RandomSource rand = world.getRandom();
        if (++this.changePowerTimer >= 40) {
            this.changePowerTimer = 0;
            this.power1 = (double)rand.nextFloat() > 0.25 ? rand.nextIntBetweenInclusive(0, 15) : 0;
            this.power2 = (double)rand.nextFloat() > 0.25 ? rand.nextIntBetweenInclusive(0, 15) : 0;
        }
        int dx = (axis = (Direction.Axis)this.getBlockState().getValue((Property)RotatedPillarBlock.AXIS)) == Direction.Axis.X ? 1 : 0;
        int dy = axis == Direction.Axis.Y ? 1 : 0;
        int dz = axis == Direction.Axis.Z ? 1 : 0;
        this.infectAlongLine(world, this.worldPosition, rand, this.power1, dx, dy, dz);
        this.infectAlongLine(world, this.worldPosition, rand, this.power2, -dx, -dy, -dz);
        world.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 2);
    }

    private void infectAlongLine(ServerLevel world, BlockPos origin, RandomSource random, int power, int x, int y, int z) {
        SimpleParticleType particle = ModParticles.VIBRION_PARTICLE.get();
        for (int i = 1; i <= power; ++i) {
            if (this.shouldBreakNext) {
                this.shouldBreakNext = false;
                break;
            }
            BlockPos pos = origin.offset(x * i, y * i, z * i);
            BlockState next = world.getBlockState(pos);
            if (next.isCollisionShapeFullBlock((BlockGetter)world, pos) || !BlasterUtils.canTraverse(Direction.fromDelta((int)(x * i), (int)(y * i), (int)(z * i)), next, world.getBlockState(origin), this)) break;
            world.sendParticles((ParticleOptions)particle, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 1, (double)x * 0.02, (double)y * 0.02, (double)z * 0.02, 0.0);
            List hits = world.getEntitiesOfClass(LivingEntity.class, new AABB(pos), e -> !e.isSpectator());
            for (LivingEntity e2 : hits) {
                ContaminationHandler.addDose((Entity)e2, 50);
                world.sendParticles((ParticleOptions)particle, e2.getX(), e2.getY() + 0.5, e2.getZ(), 5, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.changePowerTimer = pTag.getInt("changeTimer");
        this.power1 = pTag.getInt("power1");
        this.power2 = pTag.getInt("power2");
        this.shouldBreakNext = pTag.getBoolean("shouldBreakNext");
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("changeTimer", this.changePowerTimer);
        pTag.putInt("power1", this.power1);
        pTag.putInt("power2", this.power2);
        pTag.putBoolean("shouldBreakNext", this.shouldBreakNext);
    }
}

