/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.List;
import net.farkas.wildaside.block.custom.vibrion.SporeBlaster;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.BlasterUtils;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SporeBlasterBlockEntity
extends BlasterBlockEntity {
    private int power = 0;

    public SporeBlasterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SPORE_BLASTER.get(), pos, state);
    }

    public void tickServer() {
        Level level = this.getLevel();
        int power = level.getBestNeighborSignal(this.worldPosition);
        if (power > 0) {
            this.infectAlongLine((ServerLevel)level, this.worldPosition, (Direction)this.getBlockState().getValue((Property)SporeBlaster.FACING), power, level.random);
        }
        level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 2);
    }

    private void infectAlongLine(ServerLevel world, BlockPos origin, Direction dir, int range, RandomSource rand) {
        SimpleParticleType particle = ModParticles.VIBRION_PARTICLE.get();
        for (int i = 1; i <= range; ++i) {
            if (this.shouldBreakNext) {
                this.shouldBreakNext = false;
                break;
            }
            BlockState originBlock = world.getBlockState(origin);
            BlockPos step = origin.relative(dir, i);
            BlockState nextBlock = world.getBlockState(step);
            if (world.getBlockState(step).isCollisionShapeFullBlock((BlockGetter)world, step) || !BlasterUtils.canTraverse(dir, nextBlock, originBlock, this)) break;
            double x = (double)step.getX() + rand.nextDouble();
            double y = (double)step.getY() + rand.nextDouble();
            double z = (double)step.getZ() + rand.nextDouble();
            world.sendParticles((ParticleOptions)particle, x, y, z, 1, 0.02 * (double)dir.getStepX(), 0.02 * (double)dir.getStepY(), 0.02 * (double)dir.getStepZ(), 0.0);
            List hits = world.getEntitiesOfClass(LivingEntity.class, new AABB(step), e -> !e.isSpectator());
            for (LivingEntity entity : hits) {
                ContaminationHandler.addDose((Entity)entity, 50);
                world.sendParticles((ParticleOptions)particle, entity.getX(), entity.getY() + 0.5, entity.getZ(), 5, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("power", this.power);
        pTag.putBoolean("shouldBreakNext", this.shouldBreakNext);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.power = pTag.getInt("power");
        this.shouldBreakNext = pTag.getBoolean("shouldBreakNext");
    }
}

