/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.datagen;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.block.custom.RootBushBlock;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    private final HickoryColour[] colours = HickoryColour.values();
    private final Block fallenLeaves = (Block)ModBlocks.FALLEN_HICKORY_LEAVES.get();

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "wildaside", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.VIBRION_BLOCK);
        this.blockWithItem(ModBlocks.COMPRESSED_VIBRION_BLOCK);
        this.translucentBlockWithItem(ModBlocks.VIBRION_GEL);
        this.translucentBlockWithItem(ModBlocks.LIT_VIBRION_GEL);
        this.translucentBlockWithItem(ModBlocks.VIBRION_GLASS);
        this.simpleBlockWithItem((Block)ModBlocks.LIT_VIBRION_GLASS.get(), this.translucentAll((Block)ModBlocks.VIBRION_GLASS.get()));
        this.paneBlockWithRenderType((IronBarsBlock)ModBlocks.VIBRION_GLASS_PANE.get(), this.modLoc("block/vibrion_glass"), this.modLoc("block/vibrion_glass"), "translucent");
        this.paneBlockWithRenderType((IronBarsBlock)ModBlocks.LIT_VIBRION_GLASS_PANE.get(), this.modLoc("block/vibrion_glass"), this.modLoc("block/vibrion_glass"), "translucent");
        this.simpleBlockWithItem((Block)ModBlocks.VIBRION_GROWTH.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)ModBlocks.VIBRION_GROWTH.get()).getPath(), this.blockTexture((Block)ModBlocks.VIBRION_GROWTH.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)ModBlocks.POTTED_VIBRION_GROWTH.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_vibrion_growth", ResourceLocation.withDefaultNamespace((String)"flower_pot_cross"), "plant", this.blockTexture((Block)ModBlocks.VIBRION_GROWTH.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)ModBlocks.VIBRION_SPOREHOLDER.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/vibrion_sporeholder")));
        this.simpleBlockWithItem((Block)ModBlocks.HANGING_VIBRION_VINES.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)ModBlocks.HANGING_VIBRION_VINES.get()).getPath(), this.blockTexture((Block)ModBlocks.HANGING_VIBRION_VINES.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)ModBlocks.HANGING_VIBRION_VINES_PLANT.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)ModBlocks.HANGING_VIBRION_VINES_PLANT.get()).getPath(), this.blockTexture((Block)ModBlocks.HANGING_VIBRION_VINES_PLANT.get()))).renderType("cutout"));
        this.directionalBlock((Block)ModBlocks.SPORE_BLASTER.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/spore_blaster")));
        this.simpleBlockItem((Block)ModBlocks.SPORE_BLASTER.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/spore_blaster")));
        this.directionalBlock((Block)ModBlocks.POTION_BLASTER.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/potion_blaster")));
        this.simpleBlockItem((Block)ModBlocks.POTION_BLASTER.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/potion_blaster")));
        this.blockWithItem(ModBlocks.SPORE_AIR);
        this.axisBlock((RotatedPillarBlock)ModBlocks.NATURAL_SPORE_BLASTER.get(), this.modLoc("block/substilium_soil"), this.modLoc("block/natural_spore_blaster"));
        this.simpleBlockItem((Block)ModBlocks.NATURAL_SPORE_BLASTER.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/natural_spore_blaster")));
        this.blockWithItem(ModBlocks.SUBSTILIUM_SOIL);
        this.blockWithItem(ModBlocks.COMPRESSED_SUBSTILIUM_SOIL);
        this.blockWithItem(ModBlocks.SMOOTH_SUBSTILIUM_SOIL);
        this.blockWithItem(ModBlocks.CHISELED_SUBSTILIUM_SOIL);
        this.blockWithItem(ModBlocks.SUBSTILIUM_TILES);
        this.blockWithItem(ModBlocks.CRACKED_SUBSTILIUM_TILES);
        this.wallBlock((WallBlock)ModBlocks.SUBSTILIUM_TILE_WALLS.get(), this.modLoc("block/substilium_tiles"));
        this.stairsBlock((StairBlock)ModBlocks.SUBSTILIUM_TILE_STAIRS.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_TILES.get()));
        this.slabBlock((SlabBlock)ModBlocks.SUBSTILIUM_TILE_SLAB.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_TILES.get()), this.blockTexture((Block)ModBlocks.SUBSTILIUM_TILES.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.SUBSTILIUM_TILE_BUTTON.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_TILES.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.SUBSTILIUM_TILE_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_TILES.get()));
        this.blockWithItem(ModBlocks.SUBSTILIUM_COAL_ORE);
        this.blockWithItem(ModBlocks.SUBSTILIUM_COPPER_ORE);
        this.blockWithItem(ModBlocks.SUBSTILIUM_LAPIS_ORE);
        this.blockWithItem(ModBlocks.SUBSTILIUM_IRON_ORE);
        this.blockWithItem(ModBlocks.SUBSTILIUM_GOLD_ORE);
        this.blockWithItem(ModBlocks.SUBSTILIUM_REDSTONE_ORE);
        this.blockWithItem(ModBlocks.SUBSTILIUM_DIAMOND_ORE);
        this.blockWithItem(ModBlocks.SUBSTILIUM_EMERALD_ORE);
        this.axisBlock((RotatedPillarBlock)ModBlocks.SUBSTILIUM_STEM.get(), this.modLoc("block/substilium_stem_side"), this.modLoc("block/substilium_stem_top"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_SUBSTILIUM_STEM.get(), this.modLoc("block/stripped_substilium_stem_side"), this.modLoc("block/stripped_substilium_stem_top"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.SUBSTILIUM_WOOD.get(), this.modLoc("block/substilium_stem_side"), this.modLoc("block/substilium_stem_side"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_SUBSTILIUM_WOOD.get(), this.modLoc("block/stripped_substilium_stem_side"), this.modLoc("block/stripped_substilium_stem_side"));
        this.blockWithItem(ModBlocks.SUBSTILIUM_PLANKS);
        this.stairsBlock((StairBlock)ModBlocks.SUBSTILIUM_STAIRS.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.SUBSTILIUM_SLAB.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.SUBSTILIUM_BUTTON.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.SUBSTILIUM_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.SUBSTILIUM_FENCE.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.SUBSTILIUM_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.SUBSTILIUM_DOOR.get(), this.modLoc("block/substilium_door_bottom"), this.modLoc("block/substilium_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.SUBSTILIUM_TRAPDOOR.get(), this.modLoc("block/substilium_trapdoor"), true, "cutout");
        this.signBlock((StandingSignBlock)ModBlocks.SUBSTILIUM_SIGN.get(), (WallSignBlock)ModBlocks.SUBSTILIUM_WALL_SIGN.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.hangingSignBlock((Block)ModBlocks.SUBSTILIUM_HANGING_SIGN.get(), (Block)ModBlocks.SUBSTILIUM_WALL_HANGING_SIGN.get(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_PLANKS.get()));
        this.simpleBlockWithItem((Block)ModBlocks.SUBSTILIUM_SPROUTS.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)ModBlocks.SUBSTILIUM_SPROUTS.get()).getPath(), this.blockTexture((Block)ModBlocks.SUBSTILIUM_SPROUTS.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.BIOENGINEERING_WORKSTATION.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bioengineering_workstation")));
        this.simpleBlockItem((Block)ModBlocks.BIOENGINEERING_WORKSTATION.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bioengineering_workstation")));
        this.blockWithItem(ModBlocks.ENTORIUM_SHROOM);
        this.blockWithItem(ModBlocks.ENTORIUM_ORE);
        this.blockWithItem(ModBlocks.OVERGROWN_ENTORIUM_ORE);
        this.axisBlock((RotatedPillarBlock)ModBlocks.HICKORY_LOG.get(), this.modLoc("block/hickory_log_side"), this.modLoc("block/hickory_log_top"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_HICKORY_LOG.get(), this.modLoc("block/stripped_hickory_log_side"), this.modLoc("block/stripped_hickory_log_top"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.HICKORY_WOOD.get(), this.modLoc("block/hickory_log_side"), this.modLoc("block/hickory_log_side"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_HICKORY_WOOD.get(), this.modLoc("block/stripped_hickory_log_side"), this.modLoc("block/stripped_hickory_log_side"));
        this.blockWithItem(ModBlocks.HICKORY_PLANKS);
        this.stairsBlock((StairBlock)ModBlocks.HICKORY_STAIRS.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.HICKORY_SLAB.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.HICKORY_BUTTON.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.HICKORY_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.HICKORY_FENCE.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.HICKORY_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.HICKORY_DOOR.get(), this.modLoc("block/hickory_door_bottom"), this.modLoc("block/hickory_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.HICKORY_TRAPDOOR.get(), this.modLoc("block/hickory_trapdoor"), true, "cutout");
        this.signBlock((StandingSignBlock)ModBlocks.HICKORY_SIGN.get(), (WallSignBlock)ModBlocks.HICKORY_WALL_SIGN.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.hangingSignBlock((Block)ModBlocks.HICKORY_HANGING_SIGN.get(), (Block)ModBlocks.HICKORY_WALL_HANGING_SIGN.get(), this.blockTexture((Block)ModBlocks.HICKORY_PLANKS.get()));
        this.leavesBlock(ModBlocks.HICKORY_LEAVES);
        this.leavesBlock(ModBlocks.RED_GLOWING_HICKORY_LEAVES);
        this.leavesBlock(ModBlocks.BROWN_GLOWING_HICKORY_LEAVES);
        this.leavesBlock(ModBlocks.YELLOW_GLOWING_HICKORY_LEAVES);
        this.leavesBlock(ModBlocks.GREEN_GLOWING_HICKORY_LEAVES);
        ResourceLocation parentModel = this.modLoc("custom/flat_block");
        ResourceLocation tintedModel = this.modLoc("custom/flat_tinted_block");
        ModelFile[][] models = new ModelFile[this.colours.length][3];
        for (int ci = 0; ci < this.colours.length; ++ci) {
            String colName = this.colours[ci].getSerializedName();
            for (int count = 1; count <= 3; ++count) {
                String modelName = String.format("fallen_%s_leaves_%d", colName, count);
                ResourceLocation tex = this.modLoc("block/" + modelName);
                ResourceLocation chosenModel = colName == "hickory" ? tintedModel : parentModel;
                models[ci][count - 1] = ((BlockModelBuilder)this.models().withExistingParent(modelName, chosenModel)).texture("leaves", tex);
            }
        }
        this.getVariantBuilder(this.fallenLeaves).forAllStatesExcept(state -> {
            int ci = ((HickoryColour)((Object)((Object)state.getValue(FallenHickoryLeavesBlock.COLOUR)))).ordinal();
            int cnt = Mth.clamp((int)((Integer)state.getValue((Property)FallenHickoryLeavesBlock.COUNT)), (int)1, (int)3);
            Direction face = (Direction)state.getValue((Property)FallenHickoryLeavesBlock.FACING);
            int yRot = (int)face.toYRot();
            ModelFile chosen = models[ci][cnt - 1];
            return ConfiguredModel.builder().modelFile(chosen).rotationY(yRot).build();
        }, new Property[]{FallenHickoryLeavesBlock.LIGHT, FallenHickoryLeavesBlock.FIXED_LIGHTING});
        this.crossBlock(ModBlocks.HICKORY_SAPLING);
        this.crossBlock(ModBlocks.RED_GLOWING_HICKORY_SAPLING);
        this.crossBlock(ModBlocks.BROWN_GLOWING_HICKORY_SAPLING);
        this.crossBlock(ModBlocks.YELLOW_GLOWING_HICKORY_SAPLING);
        this.crossBlock(ModBlocks.GREEN_GLOWING_HICKORY_SAPLING);
        this.getVariantBuilder((Block)ModBlocks.HICKORY_ROOT_BUSH.get()).forAllStates(blockState -> {
            int age = (Integer)blockState.getValue((Property)RootBushBlock.AGE);
            String name = "block/hickory_root_bush_" + age;
            ModelBuilder model = this.models().cross(name, this.modLoc(name));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        this.crossBlock(ModBlocks.SPOTTED_WINTERGREEN);
        this.crossBlock(ModBlocks.PINKSTER_FLOWER);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private void crossBlock(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private void translucentBlockWithItem(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.translucentAll((Block)blockRegistryObject.get()));
    }

    public ModelFile translucentAll(Block block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block))).renderType("translucent");
    }

    private void leavesBlock(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().singleTexture(BuiltInRegistries.BLOCK.getKey((Object)((Block)blockRegistryObject.get())).getPath(), ResourceLocation.withDefaultNamespace((String)"block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get())));
    }

    private void saplingBlock(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void blockItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("wildaside:block/" + deferredBlock.getId().getPath()));
    }

    private void blockItem(DeferredBlock<?> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("wildaside:block/" + deferredBlock.getId().getPath() + appendix));
    }
}

